% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods__client_bearer_req.R
\name{client_bearer_req}
\alias{client_bearer_req}
\title{Build an authorized httr2 request with Bearer token}
\usage{
client_bearer_req(
  token,
  url,
  method = "GET",
  headers = NULL,
  query = NULL,
  follow_redirect = FALSE,
  check_url = TRUE
)
}
\arguments{
\item{token}{Either an \link{OAuthToken} object or a raw access token string.}

\item{url}{The absolute URL to call.}

\item{method}{Optional HTTP method (character). Defaults to "GET".}

\item{headers}{Optional named list or named character vector of extra
headers to set on the request. Header names are case-insensitive.
Any user-supplied \code{Authorization}
header is ignored to ensure the Bearer token set by this function is not
overridden.}

\item{query}{Optional named list of query parameters to append to the URL.}

\item{follow_redirect}{Logical. If \code{FALSE} (the default), HTTP redirects
are disabled to prevent leaking the Bearer token to unexpected hosts.
Set to \code{TRUE} only if you trust all possible redirect targets and
understand the security implications.}

\item{check_url}{Logical. If \code{TRUE} (the default), validates \code{url} against
\code{\link[=is_ok_host]{is_ok_host()}} before attaching the Bearer token. This rejects relative
URLs, plain HTTP to non-loopback hosts, and – when
\code{options(shinyOAuth.allowed_hosts)} is set – hosts outside the allowlist.
Set to \code{FALSE} only if you have already validated the URL and understand
the security implications.}
}
\value{
An httr2 request object, ready to be further customized or
performed with \code{\link[httr2:req_perform]{httr2::req_perform()}}.
}
\description{
Convenience helper to reduce boilerplate when calling downstream APIs.
It creates an \code{\link[httr2:request]{httr2::request()}} for the given URL, attaches the
\verb{Authorization: Bearer <token>} header, and applies the package's standard
HTTP defaults (timeout and User-Agent).

Accepts either a raw access token string or an \link{OAuthToken} object.
}
\examples{
# Make request using OAuthToken object
# (code is not run because it requires a real token from user interaction)
\dontrun{
# Get an OAuthToken
# (typically provided as reactive return value by `oauth_module_server()`)
token <- OAuthToken()

# Build request
request <- client_bearer_req(
  token, 
  "https://api.example.com/resource", 
  query = list(limit = 5)
)

# Perform request
response <- httr2::req_perform(request)
}
}
