% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approach_vaeac_torch_modules.R
\name{gauss_cat_sampler_most_likely}
\alias{gauss_cat_sampler_most_likely}
\title{A \code{\link[torch:nn_module]{torch::nn_module()}} Representing a \code{gauss_cat_sampler_most_likely}}
\usage{
gauss_cat_sampler_most_likely(
  one_hot_max_sizes,
  min_sigma = 1e-04,
  min_prob = 1e-04
)
}
\arguments{
\item{one_hot_max_sizes}{A torch tensor of dimension \code{n_features} containing the one hot sizes of the \code{n_features}
features. That is, if the \code{i}th feature is a categorical feature with 5 levels, then \code{one_hot_max_sizes[i] = 5}.
While the size for continuous features can either be \code{0} or \code{1}.}

\item{min_sigma}{For stability it might be desirable that the minimal sigma is not too close to zero.}

\item{min_prob}{For stability it might be desirable that the minimal probability is not too close to zero.}
}
\value{
A \code{gauss_cat_sampler_most_likely} object.
}
\description{
The \code{gauss_cat_sampler_most_likely} generates the most likely samples from the generative distribution
defined by the output of the vaeac. I.e., the layer will return the mean and most probable class for the Gaussian
(continuous features) and categorical (categorical features) distributions, respectively.
}
\author{
Lars Henry Berge Olsen
}
\keyword{internal}
