% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{check_loaded_namespaces}
\alias{check_loaded_namespaces}
\title{Check loaded namespaces}
\usage{
check_loaded_namespaces(action = "warn", allow_loaded_namespaces = NULL)
}
\arguments{
\item{action}{Behaviour to take if the status is not clean. Possible values are
"error", "warn", "message", and "none". The default is \code{action = "warn"}.}

\item{allow_loaded_namespaces}{Character vector containing names of packages that
are "allowed", and will not trigger an action if loaded via namespace.}
}
\value{
Invisibly returns an object of class \code{sessioncheck_status}.
}
\description{
Individual session check function that inspects the loaded namespaces.
Session checkers can produce errors, warnings, or messages if requested.
}
\details{
(packages that have been loaded but not attached). Regardless of the value of
\code{allow_loaded_namespaces}, R packages that have "base" priority (e.g., \strong{base}, \strong{utils}, and
\strong{grDevices}) do not trigger an action, nor does the \strong{sessioncheck} package itself,
since the package namespace must be loaded in order to call the function.
}
\examples{
check_loaded_namespaces(action = "message")
 
}
\seealso{
\code{\link[=check_attached_packages]{check_attached_packages()}},
\code{\link[=check_loaded_namespaces]{check_loaded_namespaces()}},
\code{\link[=check_globalenv_objects]{check_globalenv_objects()}},
\code{\link[=check_attached_environments]{check_attached_environments()}},
\code{\link[=check_sessiontime]{check_sessiontime()}},
\code{\link[=check_required_options]{check_required_options()}},
\code{\link[=check_required_locale]{check_required_locale()}},
\code{\link[=check_required_sysenv]{check_required_sysenv()}}
}
