% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_filter_helpers.R
\name{st_build_filter_url}
\alias{st_build_filter_url}
\title{Build Sensor Tower Filter URL}
\usage{
st_build_filter_url(
  os = "unified",
  category = NULL,
  countries = NULL,
  base_url = "https://app.sensortower.com/top-charts"
)
}
\arguments{
\item{os}{Character string. Operating system filter. One of "ios", "android", 
or "unified". Defaults to "unified".}

\item{category}{Optional. Category ID to pre-select.}

\item{countries}{Optional. Character vector of country codes to pre-select.}

\item{base_url}{Character string. Base URL for Sensor Tower. Defaults to 
"https://app.sensortower.com/top-charts".}
}
\value{
Character string. The constructed URL.
}
\description{
Constructs a URL for the Sensor Tower web interface where you can create
custom filters. Visit this URL, configure your filters, and then copy the
custom_fields_filter_id from the resulting URL.
}
\examples{
\dontrun{
# Build URL for iOS games in US
url <- st_build_filter_url(os = "ios", category = 6014, countries = "US")

# Open in browser
browseURL(url)
}
}
