% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{LRI_rat}
\alias{LRI_rat}
\title{A collection of rat ligand-receptor interactions.}
\format{
A list with the following items:
\enumerate{
  \item \code{LRI_curated}: a data.table of curated LRIs
  \item \code{LRI_curated_GO}: a data.table with GO terms attached to
   curated LRI
  \item \code{LRI_curated_KEGG}: a data.table with KEGG pathways attached to
   curated LRIs
   \item \code{LRI_retrieved_dates}: dates at which data have been retrieved
   from the seven external databases
  \item \code{LRI_retrieved_from}: paths or packages from where data have
   been retrieved
  \item \code{LRI_biomart_ensembl_version}: version of ensembl used for
   GO annotation and orthology conversion
}
}
\usage{
data(LRI_rat)
}
\description{
This dataset contains a data.table of curated rat ligand-receptor
 interactions as well as related annotations (GO Terms, KEGG Pathways) and
 metadata.
}
\details{
The dataset has been built internally in scDiffCom according to
 \code{scDiffCom:::build_LRI(species = "rat")}. The LRIs have been retrieved
 from seven databases (see References). Note that only curated LRIs
 have been kept.
}
\references{
CellChat (\href{https://pubmed.ncbi.nlm.nih.gov/33597522/}{PMID: 33597522}),
 CellPhoneDB (\href{https://pubmed.ncbi.nlm.nih.gov/32103204/}{PMID: 32103204}),
 CellTalkDB (\href{https://pubmed.ncbi.nlm.nih.gov/33147626/}{PMID: 33147626}),
 connectomeDB2020 (\href{https://pubmed.ncbi.nlm.nih.gov/33024107/}{PMID: 33024107}),
 ICELLNET (\href{https://pubmed.ncbi.nlm.nih.gov/33597528/}{PMID: 33597528}),
 NicheNet (\href{https://pubmed.ncbi.nlm.nih.gov/31819264/}{PMID: 31819264}),
 SingleCellSignalR (\href{https://pubmed.ncbi.nlm.nih.gov/32196115/}{PMID: 32196115})
}
\keyword{datasets}
