% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-session.R
\name{sas_get_session}
\alias{sas_get_session}
\title{Get current SAS session}
\usage{
sas_get_session()
}
\value{
\code{saspy.sasbase.SASsession}; Current SAS session.
}
\description{
Returns the current SAS session, which can be used to extend \code{sasquatch}
functionality or access the current session within Python.
}
\details{
\subsection{Extending \code{sasquatch} functionality}{

\code{SASPy} has a wealth of functionality, some of which have not all been
implemented within \code{sasquatch}. \code{sas_get_session()} offers a gateway to
unimplemented functionality within the
\href{https://sassoftware.github.io/saspy/api.html#sas-session-object}{SASsession class}.
}

\subsection{Using Python}{

When utilizing Python, R, and SAS, start the session within R using
\code{sas_connect()} and utilize \code{reticulate} to pass the
\code{saspy.sasbase.SASsession} object to Python.
}
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
sas_connect()

sas_get_session()
\dontshow{\}) # examplesIf}
}
\seealso{
Other session management functions: 
\code{\link{sas_connect}()},
\code{\link{sas_disconnect}()}
}
\concept{session management functions}
