#ifndef __ADMM_H
#define __ADMM_H

void admm_gauss(int M,
                int n,
                int korder,
                Rcpp::NumericVector const& y,
                Rcpp::NumericVector const& x,
                Rcpp::NumericVector const& w,
                Rcpp::NumericVector& theta,
                Rcpp::NumericVector& z,
                Rcpp::NumericVector& u,
                double rho,
                double lam_z,
                Eigen::SparseMatrix<double> const& DD,
                double tol,
                int& iter);
void prox_newton(int M,
                 int& Minner,
                 int Mline,
                 int n,
                 int korder,
                 Rcpp::NumericVector const& y,
                 Rcpp::NumericVector const& x,
                 Rcpp::NumericVector const& w,
                 Rcpp::NumericVector& theta,
                 Rcpp::NumericVector& z,
                 Rcpp::NumericVector& u,
                 double lambda,
                 double rho,
                 double alpha,
                 double gamma,
                 Eigen::SparseMatrix<double> const& DD,
                 double tol,
                 int& total_iter);
Rcpp::List prox_newton_testing(int M,
                               int Minner,
                               int Mline,
                               int korder,
                               Rcpp::NumericVector const& y,
                               Rcpp::NumericVector const& x,
                               Rcpp::NumericVector const& w,
                               double lambda,
                               double ls_alpha,
                               double ls_gamma,
                               double tol);
#endif
