% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/restore.R
\name{restore}
\alias{restore}
\alias{restore,character-method}
\title{Restore Library}
\usage{
restore(ssimLibraryBackup, folder = NULL, session = NULL)

\S4method{restore}{character}(ssimLibraryBackup, folder = NULL, session = NULL)
}
\arguments{
\item{ssimLibraryBackup}{character string. Path to a library backup file}

\item{folder}{character string. Optional path to a folder to restore
the library into. If NULL, restores to default location. If the folder
specified does not exist, it will be created.}

\item{session}{SyncroSim session.}
}
\value{
Invisibly returns \code{TRUE} upon success (i.e. successful restore)
and \code{FALSE} upon failure.
}
\description{
Restores a SyncroSim library from a backup file.
}
\examples{
\dontrun{
# Specify file path and name of SsimLibrary backup file
myLibraryBackupName <- file.path(tempdir(), "testlib.ssimbak")

# Set up a SyncroSim Session and restore SsimLibrary from backup file
mySession <- session()
restore(ssimLibraryBackup = myLibraryBackupName,
        session = mySession)

}

}
