% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert-vs-to-tm.R
\name{convert_vs_to_tm_theme}
\alias{convert_vs_to_tm_theme}
\title{Convert a Visual Studio Code/Positron theme into a TextMate theme}
\usage{
convert_vs_to_tm_theme(
  path,
  outfile = tempfile(fileext = ".tmTheme"),
  name = NULL,
  author = NULL
)
}
\arguments{
\item{path}{Path or URL to a Visual Studio Code/Positron theme, in \code{.json}
format.}

\item{outfile}{Path where the resulting file will be written. By default
a temporary file (\code{\link[=tempfile]{tempfile()}}).}

\item{name}{Optional. The name of the theme. If not provided, the name of
the theme in \code{path} will be used.}

\item{author}{Optional. The author of the theme. If not provided, the author
from \code{path} will be used, or a default value will be assigned.}
}
\value{
This function is called for its side effects: it writes a \code{.tmTheme}
file to \code{outfile} and returns the path.
}
\description{
Read a \code{.json} file representing a Visual Studio Code/Positron theme and
write the equivalent TextMate theme (\code{.tmTheme}).
}
\examples{

vstheme <- system.file("ext/test-simple-color-theme.json",
  package = "rstudiothemes"
)
path <- convert_vs_to_tm_theme(vstheme)

readLines(path) |>
  head(50) |>
  cat(sep = "\n")

}
\seealso{
Other functions for creating themes: 
\code{\link{convert_tm_to_vs_theme}()},
\code{\link{convert_to_rstudio_theme}()}
}
\concept{functions for creating themes}
