% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sixel.R
\name{sixel}
\alias{sixel}
\title{SIXEL graphics device}
\usage{
sixel(
  file = "",
  width = 480,
  height = 480,
  max.colors = 256,
  iter.max = 10,
  background = "white",
  ...
)
}
\arguments{
\item{file}{A connection, or a character string naming the file to print to.
This parameter will be passed to \code{cat}. Default is "" (stdout).}

\item{width}{integer, width of the output image in pixels. Default is 480.}

\item{height}{integer, height of the output image in pixels. Default is 480.}

\item{max.colors}{integer, max colors of the palette. The maximum is 256.
This parameter will be passed to \code{\link{sixelEncode}}. Default is 256.}

\item{iter.max}{integer, maximum number of iterations for k-means clustering.
This parameter will be passed to \code{\link{sixelEncode}}. Default is 10.}

\item{background}{character, background color to blend with for pixel with
transparency. Default is "white".}

\item{...}{Additional arguments passed to \code{png()}.}
}
\value{
The device number (invisible).
}
\description{
A graphics device that outputs SIXEL sequences to the console when closed.
This device wraps the png() device and encodes the output as SIXEL.
}
\examples{
sixel()
plot(c(1, 2))
dev.off()
}
