% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tol.R
\name{tol_mrca}
\alias{tol_mrca}
\alias{tax_sources.tol_mrca}
\alias{unique_name.tol_mrca}
\alias{tax_name.tol_mrca}
\alias{tax_rank.tol_mrca}
\alias{ott_id.tol_mrca}
\alias{source_list.tol_mrca}
\title{MRCA of taxa from the synthetic tree}
\usage{
tol_mrca(ott_ids = NULL, node_ids = NULL, ...)

\method{tax_sources}{tol_mrca}(tax, ...)

\method{unique_name}{tol_mrca}(tax, ...)

\method{tax_name}{tol_mrca}(tax, ...)

\method{tax_rank}{tol_mrca}(tax, ...)

\method{ott_id}{tol_mrca}(tax, ...)

\method{source_list}{tol_mrca}(tax, ...)
}
\arguments{
\item{ott_ids}{Numeric vector. The ott ids for which the MRCA is desired.}

\item{node_ids}{Character vector. The node ids for which the MRCA is desired.}

\item{...}{additional arguments to customize the API call (see
\code{\link{rotl}} for more information).}

\item{tax}{an object returned by \code{tol_mrca()}.}
}
\value{
An invisible list of the MRCA node properties:

\describe{

    \item{mrca}{List of node properties.}

    \describe{
        \item{node_id}{String. The canonical identifier of the node.}

        \item{num_tips}{Numeric. The number of descendant tips.}

        \item{taxon}{A list of taxonomic properties. Only returned if
        the queried node is a taxon. (If the node is not a taxon, a
        \code{nearest_taxon} list is returned (see below)).}

            \describe{
                \item{ott_id}{Numeric. The OpenTree Taxonomy ID (ottID).}

                \item{name}{String. The taxonomic name of the queried node.}

                \item{unique_name}{String. The string that uniquely
                identifies the taxon in OTT.}

                \item{rank}{String. The taxonomic rank of the taxon in OTT.}

               \item{tax_sources}{List. A list of identifiers for taxonomic
                sources, such as other taxonomies, that define taxa judged
                equivalent to this taxon.}
            }

        The following properties list support/conflict for the node across
        synthesis source trees. All properties involve sourceid keys and
        nodeid values (see \code{source_id_map} below) Not all properties are
        are present for every node.

        \item{partial_path_of}{List. The edge below this synthetic tree node
        is compatible with the edge below each of these input tree nodes (one
        per tree). Each returned element is reported as sourceid:nodeid.}

        \item{supported_by}{List. Input tree nodes (one per tree) that support
        this synthetic tree node. Each returned element is reported as
        sourceid:nodeid.}

        \item{terminal}{List. Input tree nodes (one per tree) that are equivalent
        to this synthetic tree node (via an exact mapping, or the input tree
        terminal may be the only terminal descended from this synthetic tree node.
        Each returned element is reported as sourceid:nodeid.}

        \item{conflicts_with}{Named list of lists. Names correspond to
        sourceid keys. Each list contains input tree node ids (one or more per tree)
        that conflict with this synthetic node.}
    }

    \item{nearest_taxon}{A list of taxonomic properties of the nearest rootward
    taxon node to the MRCA node. Only returned if the MRCA node is a not taxon
    (otherwise the \code{taxon} list above is returned).}

        \describe{
            \item{ott_id}{Numeric. The OpenTree Taxonomy ID (ottID).}

            \item{name}{String. The taxonomic name of the queried node.}

            \item{unique_name}{String. The string that uniquely
            identifies the taxon in OTT.}

            \item{rank}{String. The taxonomic rank of the taxon in OTT.}

           \item{tax_sources}{List. A list of identifiers for taxonomic
            sources, such as other taxonomies, that define taxa judged
            equivalent to this taxon.}
        }

    \item{source_id_map}{Named list of lists. Names correspond to the
    sourceid keys used in the support/conflict properties of the \code{mrca}
    list above. Source trees will have the following properties:}

        \describe{
            \item{git_sha}{The git SHA identifying a particular source
            version.}

            \item{tree_id}{The tree id associated with the study id used.}

            \item{study_id}{The study identifier. Will typically include
            a prefix ("pg_" or "ot_").}
        }
    The only sourceid that does not correspond to a source tree is the taxonomy,
    which will have the name "ott"+`taxonomy_version`, and the value is the
    ott_id of the taxon in that taxonomy version. "Taxonomy" will only ever
    appear in \code{supported_by}.

   }
}
\description{
Most Recent Common Ancestor for a set of nodes
}
\details{
Get the MRCA of a set of nodes on the current synthetic
    tree. Accepts any combination of node ids and ott ids as
    input. Returns information about the most recent common
    ancestor (MRCA) node as well as the most recent taxonomic
    ancestor (MRTA) node (the closest taxonomic node to the MRCA
    node in the synthetic tree; the MRCA and MRTA may be the same
    node). If they are the same, the taxonomic information will be
    in the \code{mrca} slot, otherwise they will be in the
    \code{nearest_taxon} slot of the list. If any of the specified
    nodes is not in the synthetic tree an error will be returned.

    Taxonomic methods (\code{tax_sources()}, \code{ott_id()},
    \code{unique_name()}, ...) are available on the objects
    returned by \code{tol_mrca()}. If the MRCA node is MRTA, the
    name of the object returned by these methods will start with
    \sQuote{ott}, otherwise it will start with \sQuote{mrca}.
}
\examples{
\dontrun{
birds_mrca <- tol_mrca(ott_ids=c(412129, 119214))
ott_id(birds_mrca)
tax_sources(birds_mrca)
}
}
