% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/url.R
\name{osm_url}
\alias{osm_url}
\title{Resolve a tile into a URL}
\usage{
osm_url(tile, spec)
}
\arguments{
\item{tile}{A `data.frame()` with columns `x`, `y`, and `zoom`.}

\item{spec}{An [osm_url_spec()]}
}
\value{
A character vector of URLs
}
\description{
Resolve a tile into a URL
}
\examples{
bounds <- wk::rct(
  -7514064, 5009380,
  -6261722, 6261715,
  crs = osm_crs_native()
)

tiles <- osm_tile_covering(bounds, zoom = 6)
osm_url(tiles, osm_url_spec())

}
