% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effect_simulation.R
\name{add_binary_outcome}
\alias{add_binary_outcome}
\title{Create a binary outcome from linear predictors}
\usage{
add_binary_outcome(
  data,
  linear_col = "y_linear",
  prob_col = "y_prob",
  binary_col = "y_bin"
)
}
\arguments{
\item{data}{A data frame containing effect columns prefixed with \code{"."}.}

\item{linear_col}{Name of the column to store the summed linear predictor (default \code{"y_linear"}).}

\item{prob_col}{Name of the column to store probabilities (default \code{"y_prob"}).}

\item{binary_col}{Name of the column to store binary outcomes (default \code{"y_bin"}).}
}
\value{
A \code{tibble} with added linear predictor, probability, and binary outcome columns.
}
\description{
Generates a binary outcome by summing effects, computing probabilities via the logistic function, and drawing binary outcomes.
}
\examples{
df <- tibble::tibble(.beta = 0.5, .u = rnorm(5), .error = rnorm(5))
add_binary_outcome(df)
}
