/*
 * Decompiled with CFR 0.152.
 */
package internal.toolkit.base.tsp;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.StreamSupport;
import jdplus.toolkit.base.api.timeseries.TsMoniker;
import jdplus.toolkit.base.tsp.DataSet;
import jdplus.toolkit.base.tsp.DataSource;
import jdplus.toolkit.base.tsp.DataSourceListener;
import jdplus.toolkit.base.tsp.HasDataDisplayName;
import jdplus.toolkit.base.tsp.HasDataHierarchy;
import jdplus.toolkit.base.tsp.HasDataMoniker;
import jdplus.toolkit.base.tsp.HasDataSourceBean;
import jdplus.toolkit.base.tsp.HasDataSourceList;
import jdplus.toolkit.base.tsp.HasDataSourceMutableList;
import jdplus.toolkit.base.tsp.HasFilePaths;
import jdplus.toolkit.base.tsp.fixme.Strings;
import jdplus.toolkit.base.tsp.util.DataSourcePreconditions;
import lombok.Generated;
import lombok.NonNull;
import nbbrd.io.text.Formatter;
import nbbrd.io.text.Parser;

public final class InternalTsProvider {
    public static final Consumer<Object> DO_NOTHING = o -> {};

    public static String getDisplayNameFromMessageOrClassName(IOException exception) {
        if (exception instanceof FileNotFoundException) {
            return "File not found: " + exception.getMessage();
        }
        String message = exception.getMessage();
        return !Strings.isNullOrEmpty(message) ? message : exception.getClass().getSimpleName();
    }

    @Generated
    private InternalTsProvider() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    private static final class DataSourceEventSupport {
        @Generated
        private static final Logger log = Logger.getLogger(DataSourceEventSupport.class.getName());
        private final Set<DataSourceListener> listeners;

        @NonNull
        public static DataSourceEventSupport create() {
            Set weakHashSet = Collections.newSetFromMap(new WeakHashMap());
            return new DataSourceEventSupport(Collections.synchronizedSet(weakHashSet));
        }

        private DataSourceEventSupport(@NonNull Set<DataSourceListener> listeners) {
            if (listeners == null) {
                throw new NullPointerException("listeners is marked non-null but is null");
            }
            this.listeners = listeners;
        }

        public void add(@NonNull DataSourceListener listener) {
            if (listener == null) {
                throw new NullPointerException("listener is marked non-null but is null");
            }
            this.listeners.add(Objects.requireNonNull(listener));
        }

        public void remove(@NonNull DataSourceListener listener) {
            if (listener == null) {
                throw new NullPointerException("listener is marked non-null but is null");
            }
            this.listeners.remove(Objects.requireNonNull(listener));
        }

        void fireOpened(@NonNull DataSource dataSource) {
            if (dataSource == null) {
                throw new NullPointerException("dataSource is marked non-null but is null");
            }
            this.listeners.forEach(o -> {
                try {
                    o.opened(dataSource);
                }
                catch (Exception ex) {
                    log.log(Level.WARNING, "While sending open event", ex);
                }
            });
        }

        void fireClosed(@NonNull DataSource dataSource) {
            if (dataSource == null) {
                throw new NullPointerException("dataSource is marked non-null but is null");
            }
            this.listeners.forEach(o -> {
                try {
                    o.closed(dataSource);
                }
                catch (Exception ex) {
                    log.log(Level.WARNING, "While sending close event", ex);
                }
            });
        }

        void fireAllClosed(@NonNull String providerName) {
            if (providerName == null) {
                throw new NullPointerException("providerName is marked non-null but is null");
            }
            this.listeners.forEach(o -> {
                try {
                    o.allClosed(providerName);
                }
                catch (Exception ex) {
                    log.log(Level.WARNING, "While sending closeall event", ex);
                }
            });
        }

        void fireChanged(@NonNull DataSource dataSource) {
            if (dataSource == null) {
                throw new NullPointerException("dataSource is marked non-null but is null");
            }
            this.listeners.forEach(o -> {
                try {
                    o.changed(dataSource);
                }
                catch (Exception ex) {
                    log.log(Level.WARNING, "While sending change event", ex);
                }
            });
        }
    }

    public static final class NoOpDataHierarchy
    extends ProviderPart
    implements HasDataHierarchy {
        public NoOpDataHierarchy(String providerName) {
            super(providerName);
        }

        @Override
        @NonNull
        public List<DataSet> children(@NonNull DataSource dataSource) throws IllegalArgumentException, IOException {
            if (dataSource == null) {
                throw new NullPointerException("dataSource is marked non-null but is null");
            }
            this.checkProvider(dataSource);
            return Collections.emptyList();
        }

        @Override
        @NonNull
        public List<DataSet> children(@NonNull DataSet parent) throws IllegalArgumentException, IOException {
            if (parent == null) {
                throw new NullPointerException("parent is marked non-null but is null");
            }
            this.checkProvider(parent);
            return Collections.emptyList();
        }
    }

    public static final class FilePathSupport
    implements HasFilePaths {
        private static final File[] EMPTY = new File[0];
        private final Runnable onPathsChange;
        private final AtomicReference<File[]> paths;

        public FilePathSupport(Runnable onPathsChange) {
            this.onPathsChange = Objects.requireNonNull(onPathsChange);
            this.paths = new AtomicReference<File[]>(EMPTY);
        }

        @Override
        public void setPaths(File[] paths) {
            Object[] newValue;
            Object[] objectArray = newValue = paths != null ? (File[])paths.clone() : EMPTY;
            if (!Arrays.equals(this.paths.getAndSet((File[])newValue), newValue)) {
                this.onPathsChange.run();
            }
        }

        @Override
        public File[] getPaths() {
            return (File[])this.paths.get().clone();
        }
    }

    public static final class DataSourceMutableListSupport
    extends ProviderPart
    implements HasDataSourceMutableList {
        private final LinkedHashSet<DataSource> dataSources;
        private final DataSourceEventSupport eventSupport;
        private final Consumer<? super DataSource> cacheCleaner;

        public DataSourceMutableListSupport(String providerName, LinkedHashSet<DataSource> dataSources, Consumer<? super DataSource> cacheCleaner) {
            super(providerName);
            this.dataSources = Objects.requireNonNull(dataSources);
            this.eventSupport = DataSourceEventSupport.create();
            this.cacheCleaner = Objects.requireNonNull(cacheCleaner);
        }

        @Override
        public void reload(@NonNull DataSource dataSource) {
            if (dataSource == null) {
                throw new NullPointerException("dataSource is marked non-null but is null");
            }
            this.checkProvider(dataSource);
            this.cacheCleaner.accept(dataSource);
            this.eventSupport.fireChanged(dataSource);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean open(@NonNull DataSource dataSource) throws IllegalArgumentException {
            if (dataSource == null) {
                throw new NullPointerException("dataSource is marked non-null but is null");
            }
            this.checkProvider(dataSource);
            LinkedHashSet<DataSource> linkedHashSet = this.dataSources;
            synchronized (linkedHashSet) {
                if (this.dataSources.add(dataSource)) {
                    this.eventSupport.fireOpened(dataSource);
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean close(@NonNull DataSource dataSource) throws IllegalArgumentException {
            if (dataSource == null) {
                throw new NullPointerException("dataSource is marked non-null but is null");
            }
            this.checkProvider(dataSource);
            LinkedHashSet<DataSource> linkedHashSet = this.dataSources;
            synchronized (linkedHashSet) {
                if (this.dataSources.remove(dataSource)) {
                    this.eventSupport.fireClosed(dataSource);
                    return true;
                }
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void closeAll() {
            LinkedHashSet<DataSource> linkedHashSet = this.dataSources;
            synchronized (linkedHashSet) {
                this.dataSources.clear();
                this.eventSupport.fireAllClosed(this.providerName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @NonNull
        public List<DataSource> getDataSources() {
            LinkedHashSet<DataSource> linkedHashSet = this.dataSources;
            synchronized (linkedHashSet) {
                return List.copyOf(this.dataSources);
            }
        }

        @Override
        public void addDataSourceListener(@NonNull DataSourceListener listener) {
            if (listener == null) {
                throw new NullPointerException("listener is marked non-null but is null");
            }
            this.eventSupport.add(listener);
        }

        @Override
        public void removeDataSourceListener(@NonNull DataSourceListener listener) {
            if (listener == null) {
                throw new NullPointerException("listener is marked non-null but is null");
            }
            this.eventSupport.remove(listener);
        }
    }

    public static final class DataSourceListSupport
    extends ProviderPart
    implements HasDataSourceList {
        private final List<DataSource> dataSources;
        private final DataSourceEventSupport eventSupport;
        private final Consumer<? super DataSource> cacheCleaner;

        public DataSourceListSupport(String providerName, Iterable<DataSource> dataSources, Consumer<? super DataSource> cacheCleaner) {
            super(providerName);
            this.dataSources = StreamSupport.stream(dataSources.spliterator(), false).toList();
            this.eventSupport = DataSourceEventSupport.create();
            this.cacheCleaner = Objects.requireNonNull(cacheCleaner);
            dataSources.forEach(this::checkProvider);
        }

        @Override
        public void reload(@NonNull DataSource dataSource) {
            if (dataSource == null) {
                throw new NullPointerException("dataSource is marked non-null but is null");
            }
            this.checkProvider(dataSource);
            this.cacheCleaner.accept(dataSource);
            this.eventSupport.fireChanged(dataSource);
        }

        @Override
        @NonNull
        public List<DataSource> getDataSources() {
            return this.dataSources;
        }

        @Override
        public void addDataSourceListener(@NonNull DataSourceListener listener) {
            if (listener == null) {
                throw new NullPointerException("listener is marked non-null but is null");
            }
            this.eventSupport.add(listener);
        }

        @Override
        public void removeDataSourceListener(@NonNull DataSourceListener listener) {
            if (listener == null) {
                throw new NullPointerException("listener is marked non-null but is null");
            }
            this.eventSupport.remove(listener);
        }
    }

    public static final class DataSourceBeanSupport<T>
    extends ProviderPart
    implements HasDataSourceBean<T> {
        private final DataSource.Converter<T> param;
        private final String version;

        public DataSourceBeanSupport(String providerName, DataSource.Converter<T> param, String version) {
            super(providerName);
            this.param = Objects.requireNonNull(param);
            this.version = Objects.requireNonNull(version);
        }

        @Override
        @NonNull
        public T newBean() {
            return this.param.getDefaultValue();
        }

        @Override
        @NonNull
        public DataSource encodeBean(@NonNull Object bean) throws IllegalArgumentException {
            Objects.requireNonNull(bean);
            try {
                DataSource.Builder result = DataSource.builder(this.providerName, this.version);
                this.param.set(result, bean);
                return result.build();
            }
            catch (ClassCastException ex) {
                throw new IllegalArgumentException(ex);
            }
        }

        @Override
        @NonNull
        public T decodeBean(@NonNull DataSource dataSource) throws IllegalArgumentException {
            if (dataSource == null) {
                throw new NullPointerException("dataSource is marked non-null but is null");
            }
            this.checkProvider(dataSource);
            return this.param.get(dataSource);
        }
    }

    public static final class DataMonikerSupport
    extends ProviderPart
    implements HasDataMoniker {
        private final Formatter<DataSource> dataSourceFormatter;
        private final Formatter<DataSet> dataSetFormatter;
        private final Parser<DataSource> dataSourceParser;
        private final Parser<DataSet> dataSetParser;

        public DataMonikerSupport(String providerName, Formatter<DataSource> dataSourceFormatter, Formatter<DataSet> dataSetFormatter, Parser<DataSource> dataSourceParser, Parser<DataSet> dataSetParser) {
            super(providerName);
            this.dataSourceFormatter = Objects.requireNonNull(dataSourceFormatter);
            this.dataSetFormatter = Objects.requireNonNull(dataSetFormatter);
            this.dataSourceParser = Objects.requireNonNull(dataSourceParser);
            this.dataSetParser = Objects.requireNonNull(dataSetParser);
        }

        @Override
        @NonNull
        public TsMoniker toMoniker(@NonNull DataSource dataSource) throws IllegalArgumentException {
            if (dataSource == null) {
                throw new NullPointerException("dataSource is marked non-null but is null");
            }
            this.checkProvider(dataSource);
            String id = this.dataSourceFormatter.formatAsString((Object)dataSource);
            if (id == null) {
                throw new IllegalArgumentException("Cannot format DataSource");
            }
            return TsMoniker.of((String)this.providerName, (String)id);
        }

        @Override
        @NonNull
        public TsMoniker toMoniker(@NonNull DataSet dataSet) throws IllegalArgumentException {
            if (dataSet == null) {
                throw new NullPointerException("dataSet is marked non-null but is null");
            }
            this.checkProvider(dataSet);
            String id = this.dataSetFormatter.formatAsString((Object)dataSet);
            if (id == null) {
                throw new IllegalArgumentException("Cannot format DataSource");
            }
            return TsMoniker.of((String)this.providerName, (String)id);
        }

        @Override
        @NonNull
        public Optional<DataSet> toDataSet(@NonNull TsMoniker moniker) throws IllegalArgumentException {
            if (moniker == null) {
                throw new NullPointerException("moniker is marked non-null but is null");
            }
            this.checkProvider(moniker);
            return this.dataSetParser.parseValue((CharSequence)moniker.getId());
        }

        @Override
        @NonNull
        public Optional<DataSource> toDataSource(@NonNull TsMoniker moniker) throws IllegalArgumentException {
            if (moniker == null) {
                throw new NullPointerException("moniker is marked non-null but is null");
            }
            this.checkProvider(moniker);
            return this.dataSourceParser.parseValue((CharSequence)moniker.getId());
        }
    }

    public static final class DataDisplayNameSupport
    extends ProviderPart
    implements HasDataDisplayName {
        private final Formatter<DataSource> dataSourceFormatter;
        private final Formatter<DataSet> dataSetFormatter;

        public DataDisplayNameSupport(String providerName, Formatter<DataSource> dataSourceFormatter, Formatter<DataSet> dataSetFormatter) {
            super(providerName);
            this.dataSourceFormatter = Objects.requireNonNull(dataSourceFormatter);
            this.dataSetFormatter = Objects.requireNonNull(dataSetFormatter);
        }

        @Override
        @NonNull
        public String getDisplayName(@NonNull DataSource dataSource) throws IllegalArgumentException {
            if (dataSource == null) {
                throw new NullPointerException("dataSource is marked non-null but is null");
            }
            this.checkProvider(dataSource);
            String result = this.dataSourceFormatter.formatAsString((Object)dataSource);
            if (result == null) {
                throw new IllegalArgumentException("Cannot format DataSource");
            }
            return result;
        }

        @Override
        @NonNull
        public String getDisplayName(@NonNull DataSet dataSet) throws IllegalArgumentException {
            if (dataSet == null) {
                throw new NullPointerException("dataSet is marked non-null but is null");
            }
            this.checkProvider(dataSet);
            String result = this.dataSetFormatter.formatAsString((Object)dataSet);
            if (result == null) {
                throw new IllegalArgumentException("Cannot format DataSet");
            }
            return result;
        }
    }

    private static abstract class ProviderPart {
        protected final String providerName;

        ProviderPart(String providerName) {
            this.providerName = Objects.requireNonNull(providerName);
        }

        protected void checkProvider(DataSource dataSource) throws IllegalArgumentException {
            DataSourcePreconditions.checkProvider(this.providerName, dataSource);
        }

        protected void checkProvider(DataSet dataSet) throws IllegalArgumentException {
            DataSourcePreconditions.checkProvider(this.providerName, dataSet);
        }

        protected void checkProvider(TsMoniker moniker) throws IllegalArgumentException {
            DataSourcePreconditions.checkProvider(this.providerName, moniker);
        }
    }
}

