% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_utils.R
\name{rspdnorm}
\alias{rspdnorm}
\title{Generate Random Samples from a Riemannian Normal Distribution}
\usage{
rspdnorm(n, refpt, disp, met)
}
\arguments{
\item{n}{Number of samples to generate.}

\item{refpt}{Reference point on the manifold, represented as a symmetric positive definite matrix. Must be an object of class \code{dppMatrix} from the Matrix package.}

\item{disp}{Dispersion matrix defining the spread of the distribution. Must be an object of class \code{dppMatrix} from the Matrix package.}

\item{met}{A metric object of class \code{rmetric}.}
}
\value{
An object of class \code{CSample} containing the generated samples.
}
\description{
Simulates random samples from a Riemannian normal distribution on symmetric positive definite matrices.
}
\examples{
if (requireNamespace("Matrix", quietly = TRUE)) {
  library(Matrix)
  data(airm)
  refpt <- diag(2) |>
    Matrix::nearPD() |>
    _$mat |>
    Matrix::pack()
  disp <- diag(3) |>
    Matrix::nearPD() |>
    _$mat |>
    Matrix::pack()
  rspdnorm(10, refpt, disp, airm)
}
}
