# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

cossimVec <- function(x, y, narm) {
    .Call('_ribiosMath_cossimVec', PACKAGE = 'ribiosMath', x, y, narm)
}

#' Cluster rows of a Kappa-statistic-matrix by the hierarhical fuzzy multi-linkage partitioning method proposed by DAVID
#'
#' The function implements the Hierarhical fuzzy multi-linkage partitioning method used in the DAVID Bioinformatics tool.
#'
#' @param kappaMatrix A numeric matrix of Kappa statistics, which is likely returned by \code{\link{rowKappa}} or \code{\link{colKappa}}
#' @param kappaThr Numeric, the threshold of the Kappa statistic, which is used to select initial seeds. Default value: 0.35, as recommended by the authors of the original study based on their experiences.
#' @param initialGroupMembership Non-negative integer, the number of minimal members in initial groups. Default value: 3.
#' @param multiLinkageThr Numeric, the minimal linkage between two groups to be merged. Default value: 0.5.
#' @param mergeRule Integer, how two seeds are merged. See below.
#' 
#' Currently following merge rules are implemented:
#' \itemize{
#' \item{1 (OR RULE) length of intersect divided by length of \emph{either} seeds no less than \code{multiLinkageThr}. Empirical evidence suggests that it is a bit coarse grain than the native DAVID clustering algorithm, but the performance is quite good judged by biological relevance.}
#' \item{2 (AND RULE) length of intersect divided by length of \emph{both} seeds no less than \code{multiLinkageThr}, which gives slightly fragmented cluster by empirical experieince}
#' \item{3 (UNION RULE) length of intersect divided by length of the union no less than \code{multiLinkageThr}, which performs similar to the \emph{AND RULE} above.}
#' \item{4 (GMEAN RULE) Geometric mean of length of intersect divided by length of \emph{both} seeds no less than \code{multiLinkageThr}, the clusters tend to be highly fragemented.}
#' \item{5 (AMEAN RULE) Arithmetic mean of length of intersect divided by length of \emph{both} seeds no less than \code{multiLinkageThr}, a few items tend to appear in multiple clusters.}
#' }
#' 
#' @return A list of integer vectors. Each element represents a cluster
#' and contains the indices of rows belonging to that cluster. Rows can
#' appear in multiple clusters (fuzzy clustering).
#'
#' @author Jitao David Zhang <jitao_david.zhang@roche.com>
#'
#' @note
#' The function has only been tested in a few anecdotal examples. Cautions and more systematic tests are required before it is applied to critical datasets.
#'
#' @references
#' Huang et al. The DAVID Gene Functional Classification Tool: a novel
#' biological module-centric algorithm to functionally analyze large gene
#' lists. Genome Biology, 2007. \doi{10.1186/gb-2007-8-9-r183}
#'
#' @examples 
#' synData <- matrix(c(rep(c(rep(1, 10), rep(0, 5)), 3),
#' rep(0, 4), rep(1, 7), rep(0,4),
#' rep(c(rep(0,5), rep(1,10)), 3),
#' rep(c(rep(0,3), 1), 4)[-16]), ncol=15, byrow=TRUE)
#' rownames(synData) <- sprintf("Gene %s", letters[1:8])
#' colnames(synData) <- sprintf("t%d", 1:15)
#' synKappaMat <- rowKappa(synData)
#' synKappaMat.round2 <- round(synKappaMat, 2)
#' davidClustering_kappa(synKappaMat.round2)
#' 
#' @export
davidClustering_kappa <- function(kappaMatrix, kappaThr = 0.35, initialGroupMembership = 3L, multiLinkageThr = 0.5, mergeRule = 1L) {
    .Call('_ribiosMath_davidClustering_kappa', PACKAGE = 'ribiosMath', kappaMatrix, kappaThr, initialGroupMembership, multiLinkageThr, mergeRule)
}

#' Get empirical p-value
#' 
#' Calculate empirical p-values from real values and simulated values
#' 
#' @param stat A numeric vector of calculated statistic from the actual data
#' @param sim A numeric vector (or matrix) of simulated statistics, e.g. by Monte-Carlo methods.
#' 
#' @details
#' The estimate of the P-value is obtained as \eqn{\hat{p}=(r+1)/(n+1)},
#' where \code{n} is the number of replicate samples that have been
#' simulated and \code{r} is the number of these replicates that produce
#' a test statistic greater than or equal to that calculated for the
#' actual data.
#' 
#' @return A vector of empirical p-values, of the same length as the input
#' 
#' @references
#' \itemize{
#' \item{Davison AC, Hinkley DV (1997) Bootstrap methods and their
#' applications. Cambridge University Press, Cambridge, United Kindom.}
#' \item{North BV, Curtis D, Sham PC (2002) A note on the calculation of
#' empirical p values from Monte Carlo Procedures. Am J Hum Genet. 2002
#' August; 71(2):439--441.}
#' }
#' @author
#' Jitao David Zhang <jitao_david.zhang@roche.com>
#' 
#' @examples
#' set.seed(1995)
#' testStat <- c(-100, -3, -1, 0, 1, 3, 100)
#' testSim <- rnorm(1000)
#' empval(stat=testStat, sim=testSim)
#' @export
empval <- function(stat, sim) {
    .Call('_ribiosMath_empval', PACKAGE = 'ribiosMath', stat, sim)
}

#' Calculate column-wise kappa statistics of a matrix
#'
#' The function returns column-wise kappa statistics of a matrix, using a linear algebra procedure implemented in C++.
#'
#' @param matrix An adjacency matrix, containing values of either 0 or 1 (default), or values between 0 and 1 (weighted).
#' @param minOverlap Integer, minimal overlap between two columns in order to be considered. Pairs with fewer overlaps will return \code{NA}.
#' @return
#' A matrix of size \eqn{n \times n} if the input matrix is of size \eqn{m \times n}. 
#'
#' @note
#' A kappa statistics of value 1 indicates perfect agreement. A value of 0
#' indicates no agreement. Note that the value can be negative, which implies
#' the agreement is worse than random.
#'
#' @family kappa functions
#' @seealso \code{\link{rowKappa}} to calculate the statistic of rows
#' 
#' @examples
#' testMat <- cbind(c(1,1,0,0,1,0), c(1,1,0,1,1,0))
#' colKappa(testMat)
#' 
#' @export
colKappa <- function(matrix, minOverlap = 0L) {
    .Call('_ribiosMath_colKappa', PACKAGE = 'ribiosMath', matrix, minOverlap)
}

colKappaSimp <- function(Xs, minOverlap = 0L) {
    .Call('_ribiosMath_colKappaSimp', PACKAGE = 'ribiosMath', Xs, minOverlap)
}

#' Calculate row-wise kappa statistics of a matrix
#'
#' The function returns row-wise kappa statistics of a matrix, using a linear algebra procedure implemented in C++.
#'
#' @param matrix An adjacency matrix, containing values of either 0 or 1.
#' @param minOverlap Integer, minimal overlap between two columns in order to be considered. Pairs with fewer overlaps will return \code{NA}.
#' @return
#' A matrix of size \eqn{m \times m} if the input matrix is of size \eqn{m \times n}.
#'
#' @note
#' A kappa statistics of value 1 indicates perfect agreement. A value of 0
#' indicates no agreement. Note that the value can be negative, which implies
#' the agreement is worse than random.
#'
#' @family kappa functions
#' @seealso \code{\link{colKappa}} to calculate the statistic of rows
#' 
#' @examples
#' testMat <- cbind(c(1,1,0,0,1,0), c(1,1,0,1,1,0), c(0,1,0,0,1,0), c(1,0,1,0,1,0))
#' rowKappa(testMat)
#' stopifnot(identical(rowKappa(testMat), colKappa(t(testMat))))
#' @export
rowKappa <- function(matrix, minOverlap = 0L) {
    .Call('_ribiosMath_rowKappa', PACKAGE = 'ribiosMath', matrix, minOverlap)
}

