% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseFuncs.R
\name{parseFiles}
\alias{parseFiles}
\title{Parse files from command-line options}
\usage{
parseFiles(
  str,
  sep = ",",
  pattern = NULL,
  recursive = TRUE,
  ignore.case = TRUE
)
}
\arguments{
\item{str}{A character string}

\item{sep}{Seperator used in the string}

\item{pattern}{Pattern string, if given, only files matching the pattern will be returned}

\item{recursive}{In cse of directory or compressed files, whether files should be found recursively}

\item{ignore.case}{In case of directory or compressed files, whether case should be ignored}
}
\value{
A character vector of file paths.
}
\description{
Parse files from command line option, which can be (1) a string vector of files, (2) a file listing input files (e.g. pointer file), (3) a directory, or (4) a zip/tar/gz file (determined by suffix). In the later two cases, file patterns can be specified.
}
\note{
In case of compressed files, a temp dir will be created: the user should take care of cleaning up!
}
