% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parseFuncs.R
\name{parseFactor}
\alias{parseFactor}
\title{Parse a character string into factor}
\usage{
parseFactor(str, rlevels = NULL, make.names = TRUE, collapse = ",")
}
\arguments{
\item{str}{A character string giving groups}

\item{rlevels}{A character string giving levels}

\item{make.names}{Logical, should names be converted to adhere to the rule of variable names in R}

\item{collapse}{Character used in \code{relevels} to collapse different levels}
}
\value{
A factor parsed from the input string with the specified levels.
}
\description{
Parse a character string into factor
}
\examples{
parseFactor("A,B,C,B,A", rlevels="A,B,C")

rgroup <- "A,B,C,D,B,C,A,D,B"
rlevels <- "D,A,B,C"
parseFactor(rgroup, rlevels)

groups <- c("ATest", "Control", "Control", "ATest")
levels <- c("Control", "ATest")
makeFactor(groups, levels)

# if 'groups' is a factor and 'levels' NULL or missing, its levels are respected
groups <- factor(c("B", "C", "A", "D"), levels=c("D","C","A","B"))
makeFactor(groups)

\donttest{
groups <- c("ATest", "Control", "Control", "ATest")
levels <- c("Control", "ATest", "Unknown")
makeFactor(groups, levels)

groups <- c("ATest", "Control", "Control", "ATest", "BTest")
levels <- c("Control", "ATest")
try(makeFactor(groups, levels))
}

}
