% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reeb-graph-persistence.R
\name{reeb_graph_persistence}
\alias{reeb_graph_persistence}
\alias{reeb_graph_persistence.default}
\alias{reeb_graph_persistence.igraph}
\alias{reeb_graph_persistence.network}
\alias{reeb_graph_persistence.reeb_graph}
\alias{reeb_graph_persistence.reeb_graph_pairs}
\title{Compute Extended Persistent Homology of a Reeb Graph}
\usage{
reeb_graph_persistence(x, scale = c("value", "index", "order"), ...)

\method{reeb_graph_persistence}{default}(x, scale = c("value", "index", "order"), ...)

\method{reeb_graph_persistence}{igraph}(
  x,
  scale = c("value", "index", "order"),
  sublevel = TRUE,
  method = c("single_pass", "multi_pass"),
  values = NULL,
  ...
)

\method{reeb_graph_persistence}{network}(
  x,
  scale = c("value", "index", "order"),
  sublevel = TRUE,
  method = c("single_pass", "multi_pass"),
  values = NULL,
  ...
)

\method{reeb_graph_persistence}{reeb_graph}(
  x,
  scale = c("value", "index", "order"),
  sublevel = TRUE,
  method = c("single_pass", "multi_pass"),
  ...
)

\method{reeb_graph_persistence}{reeb_graph_pairs}(x, scale = c("value", "index", "order"), ...)
}
\arguments{
\item{x}{A \code{\link{reeb_graph}} or
\code{\link{reeb_graph_pairs}} object, or an object that can be
\link[=as_reeb_graph]{coerced to class "reeb_graph"}.}

\item{scale}{Character; the scale parameter used by the persistent pairs.
Matched to \code{"value"} (the default), \code{"index"}, or \code{"order"}.}

\item{...}{Additional arguments passed to methods.}

\item{sublevel}{Logical; whether to use the sublevel set filtration (\code{TRUE},
the default) or else the superlevel set filtration (via reversing
\code{x[["values"]]} before paring critical points.}

\item{method}{Character; the pairing method to use. Matched to
\code{"single_pass"} (the default) or \code{"multi_pass"}.}

\item{values}{For coercion \emph{to} class \code{reeb_graph}, a character value; the
node attribute to use as the Reeb graph value function. If \code{NULL} (the
default), the first numeric node attribute is used. For coercion \emph{from}
class \code{reeb_graph}, a character value; the name of the node attribute in
which to store the Reeb graph value function.}
}
\value{
A \link[phutil:persistence]{phutil::persistence} object.
}
\description{
This function obtains extended persistent homology of a Reeb
graph by way of pairing critical points.
}
\details{
The types, values, and indices of critical pairs are obtained by
\code{\link[=reeb_graph_pairs]{reeb_graph_pairs()}}. \code{reeb_graph_persistence()} calls this function
internally with the prescribed \code{method}, then restructures the values or
indices as \link[phutil:persistence]{phutil::persistence} data.

This function may be deprecated once a \code{reeb_graph_pairs} method is
written for \code{\link[phutil:persistence]{phutil::as_persistence()}}.
}
\examples{
ex_sf <- system.file("extdata", "running_example.txt", package = "rgph")
( ex_rg <- read_reeb_graph(ex_sf) )
( ex_ph <- reeb_graph_persistence(ex_rg) )
phutil::get_pairs(ex_ph, dimension = 0)
phutil::get_pairs(ex_ph, dimension = 1)

t10_f <- system.file("extdata", "10_tree_iterations.txt", package = "rgph")
( t10 <- read_reeb_graph(t10_f) )
( t10_ph <- reeb_graph_persistence(t10) )
phutil::get_pairs(t10_ph, dimension = 0)
( t10_ph <- reeb_graph_persistence(t10, scale = "index") )
phutil::get_pairs(t10_ph, dimension = 0)
( t10_ph <- reeb_graph_persistence(t10, scale = "order") )
phutil::get_pairs(t10_ph, dimension = 0)

}
\seealso{
\code{\link[=reeb_graph_pairs]{reeb_graph_pairs()}}
}
