% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ru_datetime.R
\name{ru_datetime}
\alias{ru_datetime}
\title{Add numeric datetimes to data frame that only has character versions.}
\usage{
ru_datetime(dsetin, includevars = NULL)
}
\arguments{
\item{dsetin}{Incoming data frame to have numeric datetimes added.}

\item{includevars}{Specify which variables ending in DTC will be processed.}
}
\value{
The incoming data frame with numeric dates and times added will be returned.
}
\description{
Pass in a data frame and variables ending in "DTC" will have corresponding numeric versions created and saved.
}
\examples{
library(repfun)
library(knitr)
ae <- repfun::ru_datetime(repfun::ae)
knitr::kable(head(ae[,grepl('(DT$|TM$|DTC$)',names(ae))],5),
             caption = "After Invoking ru_labels()")

}
\author{
Yongwei Wang, \email{yongwei.x.wang@viivhealthcare.com} \cr
Chris Rook, \email{cr883296@gmail.com}
}
