% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readDWD.R
\name{readDWD.asczip}
\alias{readDWD.asczip}
\title{read dwd gridded asc data}
\usage{
readDWD.asczip(file, ascmeta = FALSE, quiet = rdwdquiet(), ...)
}
\arguments{
\item{file}{Name of file on harddrive, like e.g.
DWDdata/annual/radiation_global/grids_germany_annual_radiation_global_2024.zip}

\item{ascmeta}{Logical: return meta data from asc file as a vector with ca 20 string elements?
DEFAULT: FALSE}

\item{quiet}{Ignored.
DEFAULT: FALSE through \code{\link[=rdwdquiet]{rdwdquiet()}}}

\item{\dots}{Further arguments passed to \code{\link[terra:rast]{terra::rast()}}}
}
\value{
\code{\link[terra:rast]{terra::rast}} object
}
\description{
Read gridded asc data.
Intended to be called via \code{\link[=readDWD]{readDWD()}}.\cr
}
\examples{
\dontrun{ # Excluded from CRAN checks, but run in localtests
link <- "annual/radiation_global/grids_germany_annual_radiation_global_2022.zip" # 0.1 MB
file <- dataDWD(link, base=gridbase, joinbf=TRUE, read=FALSE)
meta <- readDWD(file, ascmeta=TRUE)
str(meta)
grid <- readDWD(file)
plotRadar(grid, proj="seasonal", extent="seasonal")
}
}
\seealso{
\code{\link[=readDWD]{readDWD()}}
}
\author{
Berry Boessenkool, \email{berry-b@gmx.de}, Jan 2025
}
