% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcatfish_search.R
\name{rcatfish_search}
\alias{rcatfish_search}
\title{Search for genera and species in the Eschmeyer's Catalog of Fishes}
\usage{
rcatfish_search(
  query,
  type,
  unavailable = FALSE,
  taxon.history = FALSE,
  resolve = FALSE,
  sleep.time = 10,
  phrase = FALSE,
  verbose = TRUE,
  common.name = FALSE,
  language = "English"
)
}
\arguments{
\item{query}{Character or Character Vector containing the name or names of the taxon to search. Note, you can not mix common and scientific names as a query.}

\item{type}{Character either "Genus" or "Species" to search for genera and species respectively.
Note that only one of these options can be chosen.}

\item{unavailable}{Logical. Should the query be run with unavailable names include? Default is FALSE.}

\item{taxon.history}{Should a detailed history of taxonomic changes per taxa be returned (i.e. synonymization, raised to validity, authority, etc.). Default is FALSE.}

\item{resolve}{Logical. If a match for the query isn't found, should an attempt be made to resolve the name using taxize?}

\item{sleep.time}{Numeric. Time in seconds to sleep between query calls to the California Academy of Sciences page. This is set by default to 10 seconds, which is in their robots.txt. Adjust at your own risk.}

\item{phrase}{Logical. Should query be passed as a quoted phrase (e.g. "Synonym of Cyprinus carpio"). Default is FALSE.}

\item{verbose}{Logical. Should query progress be messaged to the screen? Default is TRUE.}

\item{common.name}{Is the query a common name? Common names will be converted to scientific names for searching through rfishbase. Note, you can not mix common and scientific names as a query. This likely will only work for species searches. Default is FALSE.}

\item{language}{Language to perform common name search. Default is English.}
}
\value{
Data frames. If taxon.history = TRUE, a list of two data frames. In this case, the first data frame TaxonSummary contains information on the description and current
status of the taxa in the query, references to descriptions, and information on the type locality, types, family/subfamily, distribution, and habitat for species and type species
gender, status, and authorities for genera searches. The second data frame, TaxonHistory contains detailed information on the taxonomic history
of a taxon, such as which authorities have viewed it as a synonym or valid since its description. An itemized list describing the contents in the columns of the data returned is described below.
\itemize{
\item Query - Character. The submitted query.
\item Nominal Taxa - Character. Nominal taxonomic names.
\item Author - Character. Authorship of the species/Genus description.
\item DescriptionRef - Character. Eschmeyer Catalog of Fishes reference number for the genus or species description.
\item DescriptionYear - Numeric. Year in which taxon was described.
\item Status - Character. Current status of the nominal taxon.
\item CurrentNomenclature - Character. Currently recognized taxonomic name of the taxon.
\item CurrentAuthority - Character. Current authority for the valid name of the taxon.
\item Holotype - Character. Catalog number of the holotype.
\item Paratype - Character. Catalog number(s) of the paratypes.
\item Lectotype - Character. Catalog number of the lectotype.
\item Paralectotype - Character. Catalog number(s) of the paralectotype.
\item Neotype - Character. Catalog number of the neotype.
\item Syntype - Character. Catalog number(s) of the syntypes.
\item NoTypes - Character. Specifies entries with currently no known types.
\item TypeLocality - Character. Type locality of the taxon.
\item Family - Character. Family the taxon belongs to.
\item Subfamily - Character. Subfamily the taxon belongs to.
\item Distribution - Character. Distribution of the species.
\item Fresh - Numeric. Binary presence (1) or absence (0) in freshwater.
\item Brackish - Numeric. Binary presence (1) or absence (0) in brackish water.
\item Marine - Numeric. Binary presence (1) or absence (0) in marine water.
\item IUCNYear - Numeric. Year in which IUCN status was assessed.
\item IUCNStatus - Character. Status in the IUCN list of threatened species.
\item NomenclatureNotes - Character. Descriptive tags identifying status as a homonym, hybrid, nomen protectum, etc.
\item TypeSpecies - Character. Type Species of the genus.
\item Gender - Character. Gender of the taxon.
\item TypeBy - Character. Type designation.
\item Notes - Character. Any notes related to the taxon or taxonomic history (e.g. treated as a subspecies, availability of name, authorship issues, etc.).
\item AsSubgenus - Character. If the taxon was described as a subgenus of another genus, provides information on the genus.
\item Infrasubspecific - Character. Infrasubspecific designation if it exists.
}
}
\description{
Search for genera and species in the Eschmeyer's Catalog of Fishes
}
\details{
This function searches for genera or species in the Catalog of Fishes and returns its
valid status, synonyms, and taxonomic history as well as reference numbers for the authority of
the citations. By default, the function returns basic information on a taxon, such as who described it, its current taxonomic status, type locality,
gender of the name, etc. If users choose taxon.history = TRUE, a detailed list of taxonomic information regarding nomenclature acts associated with the taxa is also returned.
Note that the function will take longer to run, sometimes twice as long if taxon.history = TRUE.

One problem a user may encounter using the Catalog of Fishes website is that the input taxon name must match directly to a term in the database
or the database will not return any information. While this remains true using this package, users can attempt to resolve names by setting resolve = TRUE.
When resolve = TRUE, rcatfish_search will use the Global Names Resolver (GNR) in an attempt to resolve the name, which will then be passed to downstream function calls.
This is meant to be useful, but we recommend using this option be cautious about what the GNR returns. A message will print to the screen notifying you what
name the GNR resolved to be the best match and will be used, though we strongly recommend users check the resolved name does not deviate from their expectations (i.e. a homonym or similar name for a different group is not returned).
}
\examples{
#Note that for Windows OS, OpenSSL must be used as a backend for curl. 
#Please see vignette on how to do this with vignette('rcatfish').

#Search for Abactochromis and return taxon history

if((.Platform$OS.type == "windows") & (grepl(pattern = "\\\\(OpenSSL", 
  curl::curl_version()$ssl_version) == TRUE)){
cat("openSSL backend for curl is required for the Windows version of this package, but it not 
detected as being active. Please see the vignette on how to configure curl with openSSL for this
function to work. You can access the vignette with the following: vignette('rcatfish').")
}else{
my.search <- rcatfish_search(type = "Species", query = "Abactochromis", 
  taxon.history = FALSE, resolve = FALSE, sleep.time = 0)
}

#Search for the genera Astatheros and Gasteropelecidae
\donttest{
if((.Platform$OS.type == "windows") & (grepl(pattern = "\\\\(OpenSSL", 
  curl::curl_version()$ssl_version) == TRUE)){
cat("openSSL backend for curl is required for the Windows version of this package, but it not 
detected as being active. Please see the vignette on how to configure curl with openSSL for this
function to work. You can access the vignette with the following: vignette('rcatfish').")
}else{
  my.search <- rcatfish_search(type = "Genus", query = c("Astatheros","Gasteropelecidae"), 
    taxon.history = TRUE, resolve = FALSE, sleep.time = 10)
  }

#Perform a species search for two different taxa

if((.Platform$OS.type == "windows") & (grepl(pattern = "\\\\(OpenSSL", 
  curl::curl_version()$ssl_version) == TRUE)){
cat("openSSL backend for curl is required for the Windows version of this package, but it not 
detected as being active. Please see the vignette on how to configure curl with openSSL for this
function to work. You can access the vignette with the following: vignette('rcatfish').")
}else{
my.search<-rcatfish_search(type = "Species", query = c("Ctenopharynx",
  "Pseudocrenilabrus multicolor victoriae"), taxon.history = TRUE, resolve = FALSE, 
  sleep.time = 10)
  }
}

}
\references{
Fricke, R., Eschmeyer, W.N. & van der Laan, R. (Year Accessed). Eschmeyer's Catalog of Fishes: Genera, Species, References. https://researcharchive.calacademy.org/research/ichthyology/catalog/fishcatmain.asp

http://gnrd.globalnames.org/api http://gnrd.globalnames.org/
}
\author{
Samuel R. Borstein, Brandon E. Dominy, Brian C. O'Meara
}
