% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool.R
\name{pool_bootstrap_percentile}
\alias{pool_bootstrap_percentile}
\title{Bootstrap Pooling via Percentiles}
\usage{
pool_bootstrap_percentile(est, conf.level, alternative)
}
\arguments{
\item{est}{a numeric vector of point estimates from each bootstrap sample.}

\item{conf.level}{confidence level of the returned confidence interval.
Must be a single number between 0 and 1. Default is 0.95.}

\item{alternative}{a character string specifying the alternative hypothesis,
must be one of \code{"two.sided"} (default), \code{"greater"} or \code{"less"}.}
}
\description{
Get point estimate, confidence interval and p-value using
percentiles. Note that quantile "type=6" is used,
see \code{\link[stats:quantile]{stats::quantile()}} for details.
}
\details{
The point estimate is taken to be the first element of \code{est}. The remaining
n-1 values of \code{est} are then used to generate the confidence intervals.
}
