% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool.R
\name{rubin_rules}
\alias{rubin_rules}
\title{Combine estimates using Rubin's rules}
\usage{
rubin_rules(ests, ses, v_com)
}
\arguments{
\item{ests}{Numeric vector containing the point estimates from the complete-data analyses.}

\item{ses}{Numeric vector containing the standard errors from the complete-data analyses.}

\item{v_com}{Positive number representing the degrees of freedom in the complete-data analysis.}
}
\value{
A list containing:
\itemize{
\item \code{est_point}: the pooled point estimate according to Little-Rubin (2002).
\item \code{var_t}: total variance according to Little-Rubin (2002).
\item \code{df}: degrees of freedom according to Barnard-Rubin (1999).
}
}
\description{
Pool together the results from \code{M} complete-data analyses according to Rubin's rules. See details.
}
\details{
\code{rubin_rules} applies Rubin's rules (Rubin, 1987) for pooling together
the results from a multiple imputation procedure. The pooled point estimate \code{est_point} is
is the average across the point estimates from the complete-data analyses (given by the input argument \code{ests}).
The total variance \code{var_t} is the sum of two terms representing the within-variance
and the between-variance (see Little-Rubin (2002)). The function
also returns \code{df}, the estimated pooled degrees of freedom according to Barnard-Rubin (1999)
that can be used for inference based on the t-distribution.
}
\references{
Barnard, J. and Rubin, D.B. (1999).
Small sample degrees of freedom with multiple imputation. Biometrika, 86, 948-955

Roderick J. A. Little and Donald B. Rubin. Statistical Analysis with Missing
Data, Second Edition. John Wiley & Sons, Hoboken, New Jersey, 2002. [Section 5.4]
}
\seealso{
\code{\link[=rubin_df]{rubin_df()}} for the degrees of freedom estimation.
}
