% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_context.R
\name{r4sub_run_context}
\alias{r4sub_run_context}
\title{Create a Run Context}
\usage{
r4sub_run_context(
  study_id,
  environment = c("DEV", "UAT", "PROD"),
  user = NULL,
  run_id = NULL,
  timestamp = Sys.time()
)
}
\arguments{
\item{study_id}{Character. Study identifier (e.g., \code{"ABC123"}).}

\item{environment}{Character. One of \code{"DEV"}, \code{"UAT"}, \code{"PROD"}.}

\item{user}{Character or \code{NULL}. Username; defaults to system user.}

\item{run_id}{Character or \code{NULL}. If \code{NULL}, a unique ID is generated.}

\item{timestamp}{POSIXct. Defaults to current time.}
}
\value{
A list of class \code{r4sub_run_context} with elements:
\code{run_id}, \code{study_id}, \code{environment}, \code{user}, \code{created_at}.
}
\description{
A run context captures metadata for a particular evidence collection run.
It provides a unique \code{run_id}, study identifier, environment label, and
timestamps used throughout evidence ingestion.
}
\examples{
ctx <- r4sub_run_context(study_id = "STUDY001", environment = "DEV")
ctx$run_id
ctx$study_id

}
