% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decoration.R
\name{decorate.ranger}
\alias{decorate.ranger}
\title{Decorates a "ranger" object with a "variable.levels" element.}
\usage{
\method{decorate}{ranger}(x, data, ...)
}
\arguments{
\item{x}{A "ranger" object.}

\item{data}{The training dataset.}

\item{...}{Arguments to pass on to the "decorate.default" function.}
}
\description{
Decorates a "ranger" object with a "variable.levels" element.
}
\examples{
\donttest{
library("ranger")
library("r2pmml")

data(iris)
iris.ranger = ranger(Species ~ ., data = iris, num.trees = 17,
    write.forest = TRUE, probability = TRUE)
iris.ranger = decorate(iris.ranger, data = iris)
# Please uncomment the next line
#r2pmml(iris.ranger, file.path(tempdir(), "Iris-Ranger.pmml"))
}
}
