/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.lightgbm;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.ToNumberPolicy;
import com.google.gson.ToNumberStrategy;
import java.util.ArrayList;
import java.util.List;

public class PandasUtil {
    public static final String PREFIX_PANDAS_CATEGORICAL = "pandas_categorical:";

    private PandasUtil() {
    }

    public static List<List<?>> parsePandasCategorical(String string) {
        if (!string.startsWith(PREFIX_PANDAS_CATEGORICAL)) {
            throw new IllegalArgumentException(string);
        }
        string = string.substring(PREFIX_PANDAS_CATEGORICAL.length());
        JsonElement element = JsonParser.parseString((String)string);
        Gson gson = PandasUtil.createGson();
        return (List)gson.fromJson(element, ListOfLists.class);
    }

    public static String formatPandasCategorical(List<List<?>> objects) {
        Gson gson = PandasUtil.createGson();
        return PREFIX_PANDAS_CATEGORICAL + gson.toJson(objects, ListOfLists.class);
    }

    private static Gson createGson() {
        Gson result = new GsonBuilder().setObjectToNumberStrategy((ToNumberStrategy)ToNumberPolicy.LONG_OR_DOUBLE).create();
        return result;
    }

    private static class ListOfLists
    extends ArrayList<List<?>> {
        private ListOfLists() {
        }
    }
}

