% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2d.R
\name{merge_hexbin_mean}
\alias{merge_hexbin_mean}
\title{Extract hexagonal bin mean coordinates and the corresponding standardize counts.}
\usage{
merge_hexbin_mean(data_hb, counts_data, centroids_data)
}
\arguments{
\item{data_hb}{A tibble with embedding components and hexagonal bin IDs.}

\item{counts_data}{A tibble that contains hexagon IDs with the standardise
number of points within each hexagon.}

\item{centroids_data}{A tibble that contains all hexagonal bin centroid
coordinates with hexagon IDs.}
}
\value{
A tibble contains hexagon ID (\code{h}), bin means (\code{c_x}, \code{c_y}),
bin counts (\code{n_h}), and standardise counts (\code{w_h}).
}
\description{
Extract hexagonal bin mean coordinates and the corresponding standardize counts.
}
\examples{
all_centroids_df <- scurve_model_obj$hb_obj$centroids
counts_data <- scurve_model_obj$hb_obj$std_cts
umap_with_hb_id <- scurve_model_obj$hb_obj$data_hb_id
merge_hexbin_mean(data_hb = umap_with_hb_id, counts_data = counts_data,
centroids_data = all_centroids_df)

}
