% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qlm_replicate.R
\name{qlm_replicate}
\alias{qlm_replicate}
\title{Replicate a coding task}
\usage{
qlm_replicate(
  x,
  ...,
  codebook = NULL,
  model = NULL,
  batch = NULL,
  name = NULL,
  notes = NULL
)
}
\arguments{
\item{x}{A \code{qlm_coded} object.}

\item{...}{Optional overrides passed to \code{\link[=qlm_code]{qlm_code()}}, such as \code{temperature}
or \code{max_tokens}.}

\item{codebook}{Optional replacement codebook. If \code{NULL} (default), uses
the codebook from \code{x}.}

\item{model}{Optional replacement model (e.g., \code{"openai/gpt-4o"}). If \code{NULL}
(default), uses the model from \code{x}.}

\item{batch}{Optional logical to override batch processing setting. If \code{NULL}
(default), uses the batch setting from \code{x}. Set to \code{TRUE} to use batch
processing or \code{FALSE} to use parallel processing, regardless of the
original setting.}

\item{name}{Optional name for this run. If \code{NULL}, defaults to the model
name (if changed) or \code{"replication_N"} where N is the replication count.}

\item{notes}{Optional character string with descriptive notes about this
replication. Useful for documenting why this replication was run or what
differs from the original. Default is \code{NULL}.}
}
\value{
A \code{qlm_coded} object with \code{run$parent} set to the parent's run name.
}
\description{
Re-executes a coding task from a \code{qlm_coded} object, optionally with
modified settings. If no overrides are provided, uses identical settings
to the original coding.
}
\examples{
\donttest{
# First create a coded object
texts <- c("I love this!", "Terrible.", "It's okay.")
coded <- qlm_code(texts, data_codebook_sentiment, model = "openai/gpt-4o-mini", name = "run1")

# Replicate with same model
coded2 <- qlm_replicate(coded, name = "run2")

# Compare results
qlm_compare(coded, coded2, by = "sentiment", level = "nominal")
}

}
\seealso{
\code{\link[=qlm_code]{qlm_code()}} for initial coding, \code{\link[=qlm_compare]{qlm_compare()}} for comparing
replicated results.
}
