% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zstd_file_functions.R
\name{zstd_file_functions}
\alias{zstd_file_functions}
\alias{zstd_compress_file}
\alias{zstd_decompress_file}
\title{Zstd file helpers}
\usage{
zstd_compress_file(input_file, output_file, compress_level = qopt("compress_level"))

zstd_decompress_file(input_file, output_file)
}
\arguments{
\item{compress_level}{The compression level used.}

\item{input_file}{Path to the input file.}

\item{output_file}{Path to the output file.}
}
\value{
No value is returned. The file is written to disk.

No value is returned. The file is written to disk.
}
\description{
Helpers for compressing and decompressing zstd files.

A utility function to compresses a file with zstd.

A utility function to decompresses a zstd file to disk.
}
\examples{
infile <- tempfile()
writeBin(as.raw(1:5), infile)
outfile <- tempfile()
zstd_compress_file(infile, outfile, compress_level = 1)
stopifnot(file.exists(outfile))
infile <- tempfile()
writeBin(as.raw(1:5), infile)
zfile <- tempfile()
zstd_compress_file(infile, zfile, compress_level = 1)
outfile <- tempfile()
zstd_decompress_file(zfile, outfile)
stopifnot(identical(readBin(infile, what = "raw", n = 5), readBin(outfile, what = "raw", n = 5)))
}
