% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qch-package.R
\docType{package}
\name{qch-package}
\alias{qch}
\alias{qch-package}
\title{qch: Query Composite Hypotheses}
\description{
Provides functions for the joint analysis of Q sets of p-values obtained for the same list of items. This joint analysis is performed by querying a composite hypothesis, i.e. an arbitrary complex combination of simple hypotheses, as described in Mary-Huard et al. (2021) \doi{10.1093/bioinformatics/btab592} and De Walsche et al.(2025) \doi{ 10.1093/nargab/lqaf118}. In this approach, the Q-uplet of p-values associated with each item is distributed as a multivariate mixture, where each of the 2^Q components corresponds to a specific combination of simple hypotheses. The dependence between the p-value series is considered using a Gaussian copula function. A p-value for the composite hypothesis test is derived from the posterior probabilities.
}
\details{
The main functions of the package \code{\link{GetHconfig}}, \code{\link{GetH1AtLeast}},
\code{\link{GetH1Equal}},
\code{\link{qch.fit}} and \code{\link{qch.test}} correspond to the
4 steps for querying a composite hypothesis:
\itemize{
\item Building all possible combination of simple hypotheses \eqn{H_0}/\eqn{H_1}
\item Composite alternative hypothesis formulation
\item Inferring the null distribution
\item Testing the composite null hypothesis
}
}
\author{
\strong{Maintainer}: Tristan Mary-Huard \email{tristan.mary-huard@agroparistech.fr} (\href{https://orcid.org/0000-0002-3839-9067}{ORCID})

Authors:
\itemize{
  \item Annaig De Walsche \email{annaig.de-walsche@inrae.fr} (\href{https://orcid.org/0000-0003-0603-1716}{ORCID})
}

Other contributors:
\itemize{
  \item Franck Gauthier \email{franck.gauthier@inrae.fr} (\href{https://orcid.org/0000-0003-0574-065X}{ORCID}) [contributor]
}

}
\keyword{internal}
