% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modify_table1.R
\name{px_autopen}
\alias{px_autopen}
\alias{px_autopen.px}
\title{AUTOPEN}
\usage{
px_autopen(x, value, validate)

\method{px_autopen}{px}(x, value, validate = TRUE)
}
\arguments{
\item{x}{A px object}

\item{value}{Optional. A character string. If missing, the current AUTOPEN is returned. If NULL, AUTOPEN is removed.}

\item{validate}{Optional. If TRUE a number of validation checks are performed on the px object, and an error is thrown if the object is not valid. If FALSE, the checks are skipped, which can be usefull for large px objects where the check can be time consuming. Use \code{\link[=px_validate]{px_validate()}} to manually preform the check.}
}
\value{
A px object or a character string.
}
\description{
Inspect or change AUTOPEN.
}
\examples{
# Set AUTOPEN
x1 <-
   px(population_gl) |>
   px_autopen('YES')

# Print AUTOPEN
px_autopen(x1)

# Remove AUTOPEN
x2 <- px_autopen(x1, NULL)
px_autopen(x2)
}
\seealso{
\href{https://www.scb.se/globalassets/vara-tjanster/px-programmen/px-file_format_specification_2013.pdf#\%5B\%7B\%22num\%22\%3A39\%2C\%22gen\%22\%3A0\%7D\%2C\%7B\%22name\%22\%3A\%22XYZ\%22\%7D\%2C184\%2C261\%2C0\%5D}{Statistics Sweden's documentation}
}
