% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pwrcortest.r
\name{pwrcortest}
\alias{pwrcortest}
\title{Power Analysis for Pearson Correlation}
\usage{
pwrcortest(
  alternative = c("two.sided", "one.sided"),
  n_total = NULL,
  alpha = NULL,
  power = NULL,
  rho = NULL,
  method = c("t", "z"),
  bias_correction = FALSE,
  nlim = c(2, 10000)
)
}
\arguments{
\item{alternative}{Character. Either \code{"two.sided"} or \code{"one.sided"}.}

\item{n_total}{Integer scalar. Total sample size (\eqn{n}).
Must be \eqn{\ge 3} for \code{method = "t"} and \eqn{\ge 4} for \code{method = "z"}.
If \code{NULL}, the function solves for \code{n_total}.}

\item{alpha}{Numeric in \eqn{(0,1)}. If \code{NULL}, it is solved for.}

\item{power}{Numeric in \eqn{(0,1)}. If \code{NULL}, it is computed; if \code{n_total} is \code{NULL},
\code{n_total} is solved to attain this power.}

\item{rho}{Numeric correlation coefficient in \eqn{(-1,1)}, nonzero.
If \code{NULL}, \code{rho} is solved for given the other inputs.}

\item{method}{Character. Either \code{"t"} (noncentral \emph{t}-distribution)
or \code{"z"} (Fisher's \emph{z} transformation with normal approximation).}

\item{bias_correction}{Logical. Applies only to \code{method = "z"}.
If \code{TRUE}, uses the bias-corrected Fisher \emph{z}-transformation
\eqn{z_p = \operatorname{atanh}(r) + r/(2(n-1))}.}

\item{nlim}{Integer vector of length 2. Search range of \code{n_total} when solving sample size.}
}
\value{
A one-row \code{data.frame} with class
\code{"cal_power"}, \code{"cal_n"}, \code{"cal_alpha"}, or \code{"cal_es"},
depending on the solved quantity. Columns:
\itemize{
\item \code{df} (only for \code{method = "t"})
\item \code{n_total}, \code{alpha}, \code{power}
\item \code{rho}, \code{t_critical} or \code{z_critical}
\item \code{ncp} (noncentrality parameter or mean under the alternative:
see Details)
}
}
\description{
Computes statistical power, required total sample size, \eqn{\alpha},
or the minimal detectable correlation coefficient for a Pearson correlation test.
Two computational methods are supported: exact noncentral \emph{t} (\code{method = "t"})
and Fisher's \emph{z}-transformation with normal approximation (\code{method = "z"}).
}
\details{
\itemize{
\item Exactly one of \code{n_total}, \code{rho}, \code{alpha}, or \code{power}
must be \code{NULL}; that quantity is then solved.
\item For \code{method = "t"}, computations are based on the noncentral
\emph{t}-distribution with noncentrality parameter
\eqn{\lambda = \tfrac{\rho}{\sqrt{1-\rho^2}} \sqrt{n}}.
\item For \code{method = "z"}, computations use Fisher's \emph{z} transformation
of the population correlation, \eqn{z_\rho = \operatorname{atanh}(\rho)}.
Let \eqn{W = \sqrt{n-3}\, z}. Under the alternative hypothesis,
\eqn{W \sim \mathrm{Normal}(\mu,\,1)} with
\eqn{\mu = \sqrt{n-3}\, z_\rho}. If \code{bias_correction = TRUE},
\eqn{\rho} is first bias-corrected before applying Fisher's transform.
Critical values are taken from the central normal distribution under
\eqn{H_0:\rho=0} (i.e., \eqn{W \sim \mathrm{Normal}(0,1)} under the null).
The returned \code{ncp} equals \eqn{\mu}.
\item \strong{Validation against GPower:} Results have been confirmed to match
those produced by GPower for equivalent correlation tests using the
noncentral \emph{t}-distribution.
\item \emph{Note:} Results from \code{method = "z"} will not exactly match
\code{pwr::pwr.r.test}, because \code{pwr} uses a hybrid approach
combining the Fisher-\emph{z} approximation with a \emph{t}-based
critical value.
}
}
\examples{
# (1) Compute power for rho = 0.3, N = 50, two-sided test
pwrcortest(alternative = "two.sided", n_total = 50, rho = 0.3, alpha = 0.05)

# (2) Solve required N for target power, using Fisher-z method
pwrcortest(method = "z", rho = 0.2, alpha = 0.05, power = 0.8)

# (3) Solve minimal detectable correlation
pwrcortest(n_total = 60, alpha = 0.05, power = 0.9, rho = NULL)

}
