% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.aovrasch.R
\name{summary.aovrasch}
\alias{summary.aovrasch}
\title{Object Summary}
\usage{
\method{summary}{aovrasch}(object, ...)
}
\arguments{
\item{object}{\code{aovrasch} object}

\item{...}{Additional arguments affecting the summary produced.}
}
\description{
Generic \code{summary} function for the \code{aovrasch} object
}
\examples{
\dontrun{

# simulate Rasch model based data
# 100 persons, 20 items,
dat <- simul.rasch(100, items = seq(-3, 3, length.out = 20))
# reshape simulated data into 'long' format with balanced assignment 
# of examinees into two subgroups.
dat.long <- reshape.rasch(dat, group = rep(0:1, each = nrow(dat) / 2))
# apply three-way analysis of variance with mixed classification for testing the Rasch model.
res <- aov.rasch(dat.long) 
summary(res)
}
}
\author{
Takuya Yanagida \email{takuya.yanagida@univie.ac.at},
Jan Steinfeld \email{jan.steinfeld@univie.ac.at}
}
