% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power_calculation.R
\name{pwr.summary}
\alias{pwr.summary}
\title{Power for model coefficients}
\usage{
pwr.summary(object, sig.level = 0.05)
}
\arguments{
\item{object}{design object}

\item{sig.level}{significance level, default 0.05}
}
\value{
a data frame containing model coefficients, degrees of freedom (\code{df}),
type I error rate (\code{sig.level}), power, and the test direction (\code{alternative}).
}
\description{
Computes the statistical power for testing (t-test) model coefficients.
}
\examples{
rcbd <- designRCBD(
  treatments = c(2, 2),
  label = list(facA = c("1", "2"), facB = c("1", "2")),
  blocks = 12,
  formula = ~ facA*facB + (1|block),
  means = c(32, 35, 30, 37),
  vcomp = 4,
  sigma2 = 6
)
pwr.summary(rcbd)
}
