% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{promise_map}
\alias{promise_map}
\title{Promise-aware lapply/map}
\usage{
promise_map(.x, .f, ...)
}
\arguments{
\item{.x}{A vector (atomic or list) or an expression object (but not a
promise). Other objects (including classed objects) will be coerced by
base::as.list.}

\item{.f}{The function to be applied to each element of \code{.x}. The function is
permitted, but not required, to return a promise.}

\item{...}{Optional arguments to \code{.f}.}
}
\value{
A promise that resolves to a list (of values, not promises).
}
\description{
Similar to \code{\link[base:lapply]{base::lapply()}} or \code{\link[purrr:map]{purrr::map}}, but promise-aware: the \code{.f}
function is permitted to return promises, and while \code{lapply} returns a list,
\code{promise_map} returns a promise that resolves to a similar list (of resolved
values only, no promises).
}
\details{
\code{promise_map} processes elements of \code{.x} serially; that is, if \code{.f(.x[[1]])}
returns a promise, then \code{.f(.x[[2]])} will not be invoked until that promise
is resolved. If any such promise rejects (errors), then the promise returned
by \code{promise_map} immediately rejects with that err.
}
\examples{
# Waits x seconds, then returns x*10
wait_this_long <- function(x) {
  promise(\(resolve, reject) {
    later::later(\() resolve(x*10), delay = x)
  })
}

promise_map(
  list(A=1, B=2, C=3),
  wait_this_long
) |>
  then(print)

}
