% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priorsense-package.R
\docType{package}
\name{priorsense-package}
\alias{priorsense-package}
\alias{priorsense}
\title{priorsense: Prior (and likelihood) diagnostics and sensitivity
analysis}
\description{
The \pkg{priorsense} package provides functions for
prior and likelihood sensitivity analysis of Bayesian
models. Currently it implements methods to determine the
sensitivity of the posterior to power-scaling perturbations of
the prior and likelihood and is the first implementation of the
method described in Kallioinen et al. (2023).
}
\details{
The main diagnostic function provided by \pkg{priorsense}
is \code{\link{powerscale_sensitivity}}. Given a fitted model or
draws object, it computes the powerscaling sensitivity diagnostic
described in Kallioinen et al. (2023). It does so by perturbing
the prior and likelihood and computing the effect on the
posterior, without needing to refit the model (using Pareto
smoothed importance sampling and importance weighted moment
matching; Vehtari et al. 2022, Paananen et al. 2021).

In addition, visual diagnostics are available by first using
\code{\link{powerscale_sequence}} to create a sequence of perturbed
posteriors, and then a plot function such as
\code{\link{powerscale_plot_ecdf}} to visualise the change.

The following global options are available:
\itemize{
\item \code{priorsense.plot_help_text}: If \code{TRUE} (the default), priorsense plots will include a title and explanatory text. If \code{FALSE} they will not.
\item \code{priorsense.plot_variables_per_page}: Number specifying the maximum number of variables to be plotted on one page of a plot.
\item \code{priorsense.plot_ask}: If \code{TRUE} (the default), when multiple pages are plotted input is required before each subsequent page is rendered.
If \code{FALSE} no input is required.
}
}
\references{
Kallioinen, N., Paananen, T., Bürkner, P-C., Vehtari, A. (2023).
Detecting and diagnosing prior and likelihood sensitivity with
power-scaling perturbations.  \emph{Statistics and
Computing}. 34(57).  \code{doi:10.1007/s11222-023-10366-5}

Vehtari, A., Simpson, D., Gelman, A., Yao, Y., and Gabry,
J. (2024).  Pareto smoothed importance sampling. \emph{Journal of
Machine Learning Research}. 25(72).
\code{https://jmlr.org/papers/v25/19-556.html}

Paananen, T., Piironen, J., Bürkner, P-C., Vehtari, A. (2021).
Implicitly adaptive importance sampling.  \emph{Statistics and
Computing}. 31(16).  \code{doi:10.1007/s11222-020-09982-2}
}
\seealso{
\code{\link{powerscale_sensitivity}}
\code{\link{powerscale_sequence}}
\code{\link{powerscale}}
\code{\link{powerscale_plot_ecdf}}
\code{\link{powerscale_plot_dens}}
\code{\link{powerscale_plot_quantities}}
}
\author{
\strong{Maintainer}: Noa Kallioinen \email{noa.kallioinen@aalto.fi} [copyright holder]

Authors:
\itemize{
  \item Topi Paananen
  \item Paul-Christian Bürkner
  \item Aki Vehtari
}

Other contributors:
\itemize{
  \item Frank Weber [contributor]
}

}
