% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci.mean.R
\name{ci.mean}
\alias{ci.mean}
\title{Power calculation for precision analysis (confidence interval) for one mean}
\usage{
ci.mean(
  N = NULL,
  halfwidth = NULL,
  sd = 1,
  alpha = 0.05,
  power = NULL,
  cond = FALSE,
  v = FALSE
)
}
\arguments{
\item{N}{The sample size.}

\item{halfwidth}{The desired halfwidth.}

\item{sd}{The estimated standard deviation; defaults to 1.}

\item{alpha}{The significance level (type 1 error rate); defaults to 0.05.}

\item{power}{The specified level of power.}

\item{cond}{Specify whether to use unconditional or conditional probability. Defaults to FALSE (unconditional).}

\item{v}{Either TRUE for verbose output or FALSE (default) to output computed argument only.}
}
\value{
A list of the arguments (including the computed one).
}
\description{
Calculates the "power" of a confidence interval for one mean, that is, the probability
of achieving a 100(1 - alpha) percent confidence interval with halfwidth not greater
than a specified value. Can solve for power, N or alpha.
}
\details{
The unconditional probability is the probability of obtaining the desired precision
(i.e., that the observed halfwidth does not exceed the desired halfwidth)
regardless of whether or not the confidence interval includes the true parameter value.
The conditional probability is the probability of both obtaining the desired precision and having
the interval include the true parameter value.
}
\examples{
ci.mean(N = NULL, halfwidth = 0.25, power = 0.8)
ci.mean(N = 62, halfwidth = 0.25, power = NULL)
ci.mean(N = 73, halfwidth = 0.25, cond = TRUE)
}
