% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LEBubleyDyer.R
\name{LEBubleyDyer}
\alias{LEBubleyDyer}
\title{Generator of linear extensions through the Bubley-Dyer procedure.}
\usage{
LEBubleyDyer(poset, seed = NULL)
}
\arguments{
\item{poset}{An object of S4 class \code{POSet} representing the poset whose linear extensions are generated.
Argument \code{poset} must be created by using any function contained in the package aimed at building object of S4 class \code{POSet}
(e.g. \code{\link[=POSet]{POSet()}}, \code{\link[=LinearPOSet]{LinearPOSet()}}, \code{\link[=ProductPOSet]{ProductPOSet()}}, ...) .}

\item{seed}{Positive integer to initialize the random linear extension generation.}
}
\value{
An object of class \code{LEBubleyDyer}.
}
\description{
Creates an object of S4 class \code{LEBubleyDyer}, needed to sample the linear extensions of a given poset according to the Bubley-Dyer
procedure. Actually, this function does not sample the linear extensions, but just generates the object that will sample them
by using function \code{LEGet}.
}
\examples{
el <- c("a", "b", "c", "d")

dom <- matrix(c(
  "a", "b",
  "c", "b",
  "b", "d"
), ncol = 2, byrow = TRUE)

pos <- POSet(elements = el, dom = dom)

LEgenBD <- LEBubleyDyer(pos)

}
