% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/qcri_get_domains.R
\name{qcri_get_domains}
\alias{qcri_get_domains}
\title{QCRI Get Domains}
\usage{
qcri_get_domains(api_key = qcri_api_key())
}
\arguments{
\item{api_key}{The API key associated with the user account being used. If not provided, the function will attempt to retrieve it from the QCRI_API_KEY environment variable.}
}
\value{
A list with keys:
\itemize{
\item \code{success}: Boolean indicating whether the request succeeded.
\item \code{domains}: Array of supported domains, such as news, tedtalks etc. Only present if success is true.
\item \code{error}: Error message in case success is false.
}
}
\description{
This function retrieves the supported domains from the QCRI Multiterm API.
}
\examples{
\dontrun{
qcri_get_domains(api_key = "YourApiKey")
qcri_get_domains()
}
}
