% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotly.R
\name{plot_geo}
\alias{plot_geo}
\title{Initiate a plotly-geo object}
\usage{
plot_geo(data = data.frame(), ..., offline = FALSE)
}
\arguments{
\item{data}{A data frame (optional).}

\item{...}{arguments passed along to \code{\link[=plot_ly]{plot_ly()}}.}

\item{offline}{whether or not to include geo assets so that the map
can be viewed with or without an internet connection. The plotlyGeoAssets
package is required for this functionality.}
}
\description{
Use this function instead of \code{\link[=plot_ly]{plot_ly()}} to initialize
a plotly-geo object. This enforces the entire plot so use
the scattergeo trace type, and enables higher level geometries
like \code{\link[=add_polygons]{add_polygons()}} to work
}
\examples{
\dontshow{if (interactive() || !identical(.Platform$OS.type, "windows")) withAutoprint(\{ # examplesIf}

map_data("world", "canada") \%>\%
  group_by(group) \%>\%
  plot_geo(x = ~long, y = ~lat) \%>\%
  add_markers(size = I(1))
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[=plot_ly]{plot_ly()}}, \code{\link[=plot_mapbox]{plot_mapbox()}}, \code{\link[=ggplotly]{ggplotly()}}
}
\author{
Carson Sievert
}
