% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/allele_cluster.R
\name{new_germline_cluster}
\alias{new_germline_cluster}
\title{Create a GermlineCluster object}
\usage{
new_germline_cluster(
  germlineSet,
  alleleClusterSet,
  alleleClusterTable,
  threshold,
  hclustAlleleCluster = NULL,
  clusteringMethod = "hierarchical",
  communityObject = NULL,
  graphObject = NULL,
  distanceMatrix = NULL,
  silhouetteScore = NA_real_,
  resolutionParameter = NA_real_,
  locus = "IGHV"
)
}
\arguments{
\item{germlineSet}{The original germline set provided.}

\item{alleleClusterSet}{The renamed germline set with allele clusters.}

\item{alleleClusterTable}{The allele cluster table.}

\item{threshold}{The threshold used for family and allele clusters.}

\item{hclustAlleleCluster}{A hierarchical clustering object for the germline set,
or \code{NULL}.}

\item{clusteringMethod}{The clustering method used, either \code{"hierarchical"}
or \code{"leiden"}.}

\item{communityObject}{A community detection object for Leiden clustering, or \code{NULL}.}

\item{graphObject}{An \pkg{igraph} graph object for Leiden clustering, or \code{NULL}.}

\item{distanceMatrix}{The distance matrix used for clustering, or \code{NULL}.}

\item{silhouetteScore}{The silhouette score for community detection.}

\item{resolutionParameter}{The resolution parameter used for Leiden clustering.}

\item{locus}{The locus identifier, for example \code{"IGHV"}, \code{"IGHD"}, \code{"IGHJ"}.}
}
\value{
An object of class \code{"GermlineCluster"}.
}
\description{
\code{GermlineCluster} is an S3 class that stores the output of
\code{\link{inferAlleleClusters}}. It contains the allele cluster table,
clustering objects, and threshold parameters used for inference.
}
\seealso{
\code{\link{inferAlleleClusters}}

\code{\link{GermlineCluster}}
}
\concept{GermlineCluster}
