% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/community_detection.R
\name{compute_distance}
\alias{compute_distance}
\title{Compute distance matrix}
\usage{
compute_distance(
  sequences,
  method = c("hamming", "lv"),
  trim_3prime = NULL,
  quiet = TRUE,
  return_type = c("dist", "matrix")
)
}
\arguments{
\item{sequences}{A named character vector of sequences}

\item{method}{Distance method: "hamming" or "lv" (Levenshtein). Default is "hamming".}

\item{trim_3prime}{Optional position to trim sequences from 3' end}

\item{quiet}{Logical. Suppress messages. Default is TRUE.}

\item{return_type}{One of "dist" (default) or "matrix"}
}
\value{
A dist object or matrix of pairwise distances
}
\description{
Compute a pairwise distance matrix between sequences using stringdist.
}
\seealso{
\code{\link{igDistance}} for more distance options
}
\keyword{internal}
