% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ps_regions.R
\name{ps_regions_eval}
\alias{ps_regions_eval}
\title{Evaluate region numbers}
\usage{
ps_regions_eval(ps, k = 1:20, plot = TRUE, ...)
}
\arguments{
\item{ps}{A \code{phylospatial} object. Must contain a \code{dissim} component generated by \link{ps_add_dissim}.}

\item{k}{Vector of positive integers giving possible values for \code{k}. Values greater than the number of
sites in the data set will be ignored.}

\item{plot}{Logical indicating whether to print a plot of the results (\code{TRUE}, the default) or return a data
frame of the results (\code{FALSE}).}

\item{...}{Further arguments passed to \link{ps_regions}.}
}
\value{
The function generates a data frame with the following columns. If \code{plot = FALSE} the data frame is
returned, otherwise the function prints a plot of the latter variables as a function of \code{k}:
\itemize{
\item "k": The number of clusters.
\item "sse": The proportion of total variance explained, with variance defined as squared pairwise community
phylogenetic dissimilarity between sites.
\item "curvature": The local second derivative. Lower (more negative) values indicate more attractive
break-point values of k.
\item "dist11": The distance from the point to the 1:1 line on a plot of \code{k} vs \code{sse} in which k values over the
interval from 1 to the number of sites are rescaled to the unit interval. Higher values indicate more
attractive values for k.
}
}
\description{
This function compares multiple potential values for \code{k}, the number of clusters in to use in \code{ps_regions()},
to help you decide how well different numbers of regions fit your data set. For each value of \code{k}, it performs
a cluster analysis and calculates the proportion of total variance explained (SSE, the sum of squared pairwise
distances explained). It also calculates second-order metrics of the relationship between k and SSE. While
many data sets have no optimal value of \code{k} and the choice is often highly subjective, these evaluation metrics
can help you identify potential points where the variance explained stops increasing quickly as \code{k} increases.
}
\examples{
ps <- ps_add_dissim(ps_simulate())
ps_regions_eval(ps, k = 1:15, plot = TRUE)

}
