% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phoenix_coagulation.R
\name{phoenix_coagulation}
\alias{phoenix_coagulation}
\title{Phoenix Coagulation Score}
\usage{
phoenix_coagulation(
  platelets = NA_real_,
  inr = NA_real_,
  d_dimer = NA_real_,
  fibrinogen = NA_real_,
  data = parent.frame(),
  ...
)
}
\arguments{
\item{platelets}{numeric vector for platelets counts in units of 1,000/uL (thousand per microliter)}

\item{inr}{numeric vector for the international normalised ratio blood test}

\item{d_dimer}{numeric vector for D-Dimer, units of mg/L FEU}

\item{fibrinogen}{numeric vector units of mg/dL}

\item{data}{a \code{list}, \code{data.frame}, or \code{environment} containing the input vectors}

\item{...}{pass through}
}
\value{
a integer vector with values 0, 1, or 2

As with all other Phoenix organ system scores, missing values in the data
set will map to a score of zero - this is consistent with the development of
the criteria.
}
\description{
Applies the Phoenix coagulation organ dysfunction scoring to a set of inputs.
}
\section{Phoenix Coagulation Scoring}{

1 point each for platelets < 100 K/micro liter, INR > 1.3, D-dimer > 2 mg/L
FEU, and fibrinogen < 100 mg/dL, with a max total
score of 2.
}

\examples{

# using the example data set
phoenix_coagulation(
  platelets = platelets,    # 1000/uL (thousand per microliter)
  inr = inr,                # unitless
  d_dimer = d_dimer,        # mg/L FEU
  fibrinogen = fibrinogen,  # mg/dL
  data = sepsis
)

# build a data.frame with values for all possible combationations of values
# leading to all possible coagulation scores.
DF <-
  expand.grid(plts = c(NA, 20, 100, 150),
              inr  = c(NA, 0.2, 1.3, 1.8),
              ddmr = c(NA, 1.7, 2.0, 2.8),
              fib  = c(NA, 88, 100, 120))

DF$coag <- phoenix_coagulation(plts, inr, ddmr, fib, DF)
DF

}
\references{
See reference details in \code{\link{phoenix-package}} or by calling
\code{citation('phoenix')}.
}
\seealso{
\itemize{
  \item \code{\link{phoenix}} for generating the diagnostic Phoenix
    Sepsis score based on the four organ systems:
    \itemize{
      \item \code{\link{phoenix_cardiovascular}},
      \item \code{\link{phoenix_coagulation}},
      \item \code{\link{phoenix_neurologic}},
      \item \code{\link{phoenix_respiratory}},
    }
  \item \code{\link{phoenix8}} for generating the diagnostic Phoenix 8
    Sepsis criteria based on the four organ systems noted above and
    \itemize{
      \item \code{\link{phoenix_endocrine}},
      \item \code{\link{phoenix_immunologic}},
      \item \code{\link{phoenix_renal}},
      \item \code{\link{phoenix_hepatic}},
    }
}

\code{vignette('phoenix')} for more details and examples.
}
