% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/H.R
\name{H}
\alias{H}
\title{Shannon's Entropy \eqn{H(X)}}
\usage{
H(x, unit = "log2")
}
\arguments{
\item{x}{a numeric probability vector \eqn{P(X)} for which
Shannon's Entropy \eqn{H(X)} shall be computed.}

\item{unit}{a character string specifying the logarithm unit that shall be used to compute distances that depend on log computations.}
}
\value{
a numeric value representing Shannon's Entropy in bit.
}
\description{
Compute the Shannon's Entropy \eqn{H(X) = - \sum P(X) * log2(P(X))} based on a
given probability vector \eqn{P(X)}.
}
\details{
This function might be useful to fastly compute Shannon's Entropy for any
given probability vector.
}
\examples{

H(1:10/sum(1:10))

}
\references{
Shannon, Claude E. 1948. "A Mathematical Theory of
Communication". \emph{Bell System Technical Journal} \bold{27} (3): 379-423.
}
\seealso{
\code{\link{JE}}, \code{\link{CE}}, \code{\link{KL}}, \code{\link{JSD}}, \code{\link{gJSD}}
}
\author{
Hajk-Georg Drost
}
