% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitCF_MHmcmc_p.R
\name{fitCF_MHmcmc_p}
\alias{fitCF_MHmcmc_p}
\title{Generate set of parameters to be used with fitCF_MHmcmc()}
\usage{
fitCF_MHmcmc_p(
  result = stop("An output from fitCF() must be provided"),
  density = "dunif",
  accept = FALSE
)
}
\arguments{
\item{result}{An object obtained after a fitCF() fit}

\item{density}{Preset of density; can be dnorm or dunif}

\item{accept}{If TRUE, does not wait for user interaction}
}
\value{
A matrix with the parameters
}
\description{
Interactive script used to generate set of parameters to be used with fitCF_MHmcmc().\cr
}
\details{
fitCF_MHmcmc_p generates set of parameters to be used with fitCF_MHmcmc()
}
\examples{
\dontrun{
library("phenology")
data(MarineTurtles_2002)
ECFOCF_2002 <- TableECFOCF(MarineTurtles_2002)

# Paraetric model for clutch frequency
o_mu1p1_CFp <- fitCF(x = c(mu = 2.1653229641404539, 
                 sd = 1.1465246643327098, 
                 p = 0.25785366120357966), 
                 fixed.parameters=NULL, 
                 data=ECFOCF_2002, hessian = TRUE)
                           
pMCMC <- fitCF_MHmcmc_p(result=o_mu1p1_CFp, accept=TRUE)
fitCF_MCMC <- fitCF_MHmcmc(result = o_mu1p1_CFp, n.iter = 10000, 
                           parametersMCMC = pMCMC, n.chains = 1, n.adapt = 0, 
                           thin = 1, trace = FALSE)
plot(fitCF_MCMC, parameters="mu")
plot(fitCF_MCMC, parameters="sd")
plot(fitCF_MCMC, parameters="p", xlim=c(0, 0.5), breaks=seq(from=0, to=0.5, by=0.05))
plot(fitCF_MCMC, parameters="p", transform = invlogit, xlim=c(0, 1), 
     breaks=c(seq(from=0, to=1, by=0.05)))
}
}
\seealso{
Other Model of Clutch Frequency: 
\code{\link{ECFOCF_f}()},
\code{\link{ECFOCF_full}()},
\code{\link{TableECFOCF}()},
\code{\link{fitCF}()},
\code{\link{fitCF_MHmcmc}()},
\code{\link{generateCF}()},
\code{\link{lnLCF}()},
\code{\link{logLik.ECFOCF}()},
\code{\link{plot.ECFOCF}()},
\code{\link{plot.TableECFOCF}()}
}
\author{
Marc Girondot
}
\concept{Model of Clutch Frequency}
