# This file is automatically generated by data-raw/create_sdtms_data.R.
# For updating it please edit inst/extdata/sdtms-specs.json and rerun create_sdtms_data.R.
# Manual edits are not recommended, as changes may be overwritten.
#' Tumor Identification (RECIST 1.1) for Oncology
#'
#' A SDTM TU dataset using RECIST 1.1 intended for examples of ADaM dataset creation
#'
#' @name tu_onco_recist
#' @title Tumor Identification (RECIST 1.1) for Oncology
#' @keywords dataset oncology
#' @description A SDTM TU dataset using RECIST 1.1 intended for examples of ADaM dataset creation
#' @docType data
#' @format A data frame with 16 columns:
#'   \describe{
#'     \item{DOMAIN}{Domain Abbreviation}
#'     \item{STUDYID}{Study Identifier}
#'     \item{USUBJID}{Unique Subject Identifier}
#'     \item{VISIT}{Visit Name}
#'     \item{VISITNUM}{Visit Number}
#'     \item{TULOC}{Location of the Tumor/Lesion}
#'     \item{TUTESTCD}{Tumor/Lesion ID Short Name}
#'     \item{TUTEST}{Tumor/Lesion ID Test Name}
#'     \item{TUORRES}{Tumor/Lesion ID Result}
#'     \item{TUSTRESC}{Tumor/Lesion ID Result Std. Format}
#'     \item{TUMETHOD}{Method of Identification}
#'     \item{TULNKID}{Link ID}
#'     \item{TUEVAL}{Evaluator}
#'     \item{TUEVALID}{Evaluator Identifier}
#'     \item{TUACPTFL}{Accepted Record Flag}
#'     \item{TUSEQ}{Sequence Number}
#'   }
#'
#' @source Generated dataset.
#' @author Stefan Bundfuss
#' @details Contains a set of 1 unique Test Short Name and Test Name: \tabular{ll}{
#'   \strong{TUTESTCD} \tab \strong{TUTEST} \cr
#'   TUMIDENT \tab Tumor Identification
#' }

"tu_onco_recist"
