% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bt_helpers.R
\name{summarize_bt_fit}
\alias{summarize_bt_fit}
\title{Summarize a Bradley–Terry model fit}
\usage{
summarize_bt_fit(fit, decreasing = TRUE, verbose = TRUE)
}
\arguments{
\item{fit}{A list returned by \code{\link{fit_bt_model}}.}

\item{decreasing}{Logical; should higher \code{theta} values receive
lower rank numbers? If \code{TRUE} (default), the highest \code{theta}
gets \code{rank = 1}.}

\item{verbose}{Logical. If \code{TRUE} (default), emit warnings when coercing.
If \code{FALSE}, suppress coercion warnings during ranking.}
}
\value{
A tibble with columns:
\describe{
\item{ID}{Object identifier.}
\item{theta}{Estimated ability parameter.}
\item{se}{Standard error of \code{theta}.}
\item{rank}{Rank of \code{theta}; 1 = highest
(if \code{decreasing = TRUE}).}
\item{engine}{Modeling engine used ("sirt" or "BradleyTerry2").}
\item{reliability}{MLE reliability (numeric scalar) repeated on each row.}
}
}
\description{
This helper takes the object returned by \code{\link{fit_bt_model}} and
returns a tibble with one row per object (e.g., writing sample), including:
\itemize{
\item \code{ID}: object identifier
\item \code{theta}: estimated ability parameter
\item \code{se}: standard error of \code{theta}
\item \code{rank}: rank order of \code{theta} (1 = highest by default)
\item \code{engine}: modeling engine used ("sirt" or "BradleyTerry2")
\item \code{reliability}: MLE reliability (for \pkg{sirt}) or \code{NA}
}
}
\examples{
# Example using built-in comparison data
data("example_writing_pairs")
bt <- build_bt_data(example_writing_pairs)

fit1 <- fit_bt_model(bt, engine = "sirt")
fit2 <- fit_bt_model(bt, engine = "BradleyTerry2")

summarize_bt_fit(fit1)
summarize_bt_fit(fit2)

}
