% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llm_batch.R
\name{llm_download_batch_results}
\alias{llm_download_batch_results}
\title{Extract results from a pairwiseLLM batch object}
\usage{
llm_download_batch_results(x, ...)
}
\arguments{
\item{x}{An object returned by \code{\link[=llm_submit_pairs_batch]{llm_submit_pairs_batch()}} (class
\code{"pairwiseLLM_batch"}), or a compatible list that contains a \code{results}
element.}

\item{...}{Reserved for future use; currently ignored.}
}
\value{
A tibble containing batch comparison results in the standard
pairwiseLLM schema.
}
\description{
Helper to extract the parsed results tibble from a batch object returned by
\code{\link[=llm_submit_pairs_batch]{llm_submit_pairs_batch()}}. This is a thin wrapper around the \code{results}
element returned by backend-specific batch pipelines and is designed to be
forward-compatible with future, more asynchronous batch workflows.
}
\examples{
\dontrun{
# Requires running a provider batch job first (API key + internet + cost).

batch <- llm_submit_pairs_batch(
  pairs             = tibble::tibble(
    ID1   = "S01",
    text1 = "Text 1",
    ID2   = "S02",
    text2 = "Text 2"
  ),
  backend           = "openai",
  model             = "gpt-4.1",
  trait_name        = trait_description("overall_quality")$name,
  trait_description = trait_description("overall_quality")$description,
  prompt_template   = set_prompt_template()
)

res <- llm_download_batch_results(batch)
res
}

}
